/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.cr;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseJson;
import java.util.Collections;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.opencds.cqf.fhir.api.Repository;

public interface ICdsCrService {
    public IBaseParameters encodeParams(CdsServiceRequestJson var1);

    public CdsServiceResponseJson encodeResponse(Object var1);

    public FhirVersionEnum getFhirVersion();

    public Repository getRepository();

    default public Object invoke(IModelJson theJson) {
        IBaseParameters params = this.encodeParams((CdsServiceRequestJson)theJson);
        IBaseResource response = this.invokeApply(params);
        return this.encodeResponse(response);
    }

    default public IBaseResource invokeApply(IBaseParameters theParams) {
        String operationName = this.getFhirVersion() == FhirVersionEnum.R4 ? "$r5.apply" : "$apply";
        switch (this.getFhirVersion()) {
            case DSTU3: {
                return this.getRepository().invoke(org.hl7.fhir.dstu3.model.PlanDefinition.class, operationName, theParams, CarePlan.class, Collections.singletonMap("Content-Type", "application/json+fhir"));
            }
            case R4: {
                return this.getRepository().invoke(org.hl7.fhir.r4.model.PlanDefinition.class, operationName, theParams, Bundle.class, Collections.singletonMap("Content-Type", "application/json+fhir"));
            }
            case R5: {
                return this.getRepository().invoke(PlanDefinition.class, operationName, theParams, org.hl7.fhir.r5.model.Bundle.class, Collections.singletonMap("Content-Type", "application/json+fhir"));
            }
        }
        return null;
    }
}

