/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.cr.discovery;

import ca.uhn.hapi.fhir.cdshooks.api.CdsResolutionStrategyEnum;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceJson;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.discovery.ICrDiscoveryElement;
import ca.uhn.hapi.fhir.cdshooks.svc.cr.discovery.PrefetchUrlList;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.TriggerDefinition;

public class CrDiscoveryElementR5
implements ICrDiscoveryElement {
    protected PlanDefinition myPlanDefinition;
    protected PrefetchUrlList myPrefetchUrlList;

    public CrDiscoveryElementR5(PlanDefinition thePlanDefinition, PrefetchUrlList thePrefetchUrlList) {
        this.myPlanDefinition = thePlanDefinition;
        this.myPrefetchUrlList = thePrefetchUrlList;
    }

    @Override
    public CdsServiceJson getCdsServiceJson() {
        if (this.myPlanDefinition == null || !this.myPlanDefinition.hasAction() || this.myPlanDefinition.getAction().stream().noneMatch(a -> a.hasTrigger())) {
            return null;
        }
        List triggerDefs = this.myPlanDefinition.getAction().stream().filter(a -> a.hasTrigger()).flatMap(a -> a.getTrigger().stream()).filter(t -> t.getType().equals((Object)TriggerDefinition.TriggerType.NAMEDEVENT)).collect(Collectors.toList());
        if (triggerDefs == null || triggerDefs.isEmpty()) {
            return null;
        }
        CdsServiceJson service = new CdsServiceJson().setId(this.myPlanDefinition.getIdElement().getIdPart()).setTitle(this.myPlanDefinition.getTitle()).setDescription(this.myPlanDefinition.getDescription()).setHook(((TriggerDefinition)triggerDefs.get(0)).getName());
        if (this.myPrefetchUrlList == null) {
            this.myPrefetchUrlList = new PrefetchUrlList();
        }
        int itemNo = 0;
        if (!this.myPrefetchUrlList.stream().anyMatch(p -> p.equals("Patient/{{context.patientId}}") || p.equals("Patient?_id={{context.patientId}}") || p.equals("Patient?_id=Patient/{{context.patientId}}"))) {
            String key = this.getKey(++itemNo);
            service.addPrefetch(key, "Patient?_id={{context.patientId}}");
            service.addSource(key, CdsResolutionStrategyEnum.FHIR_CLIENT);
        }
        for (String item : this.myPrefetchUrlList) {
            String key = this.getKey(++itemNo);
            service.addPrefetch(key, item);
            service.addSource(key, CdsResolutionStrategyEnum.FHIR_CLIENT);
        }
        return service;
    }
}

