/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.prefetch;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.hapi.fhir.cdshooks.api.CdsResolutionStrategyEnum;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsHooksDaoAuthorizationSvc;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsServiceMethod;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestJson;
import ca.uhn.hapi.fhir.cdshooks.svc.prefetch.CdsPrefetchDaoSvc;
import ca.uhn.hapi.fhir.cdshooks.svc.prefetch.CdsPrefetchFhirClientSvc;
import ca.uhn.hapi.fhir.cdshooks.svc.prefetch.CdsResolutionStrategySvc;
import ca.uhn.hapi.fhir.cdshooks.svc.prefetch.PrefetchTemplateUtil;
import java.util.HashSet;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CdsPrefetchSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(CdsPrefetchSvc.class);
    private final CdsResolutionStrategySvc myCdsResolutionStrategySvc;
    private final CdsPrefetchDaoSvc myResourcePrefetchDao;
    private final CdsPrefetchFhirClientSvc myResourcePrefetchFhirClient;
    private final ICdsHooksDaoAuthorizationSvc myCdsHooksDaoAuthorizationSvc;

    public CdsPrefetchSvc(CdsResolutionStrategySvc theCdsResolutionStrategySvc, CdsPrefetchDaoSvc theResourcePrefetchDao, CdsPrefetchFhirClientSvc theResourcePrefetchFhirClient, ICdsHooksDaoAuthorizationSvc theCdsHooksDaoAuthorizationSvc) {
        this.myCdsResolutionStrategySvc = theCdsResolutionStrategySvc;
        this.myResourcePrefetchDao = theResourcePrefetchDao;
        this.myResourcePrefetchFhirClient = theResourcePrefetchFhirClient;
        this.myCdsHooksDaoAuthorizationSvc = theCdsHooksDaoAuthorizationSvc;
    }

    public void augmentRequest(CdsServiceRequestJson theCdsServiceRequestJson, ICdsServiceMethod theServiceMethod) {
        CdsServiceJson serviceSpec = theServiceMethod.getCdsServiceJson();
        Set<String> missingPrefetch = this.findMissingPrefetch(serviceSpec, theCdsServiceRequestJson);
        if (missingPrefetch.isEmpty()) {
            return;
        }
        Set<CdsResolutionStrategyEnum> strategies = this.myCdsResolutionStrategySvc.determineResolutionStrategy(theServiceMethod, theCdsServiceRequestJson);
        String serviceId = theServiceMethod.getCdsServiceJson().getId();
        try {
            this.fetchMissingPrefetchElements(theCdsServiceRequestJson, serviceSpec, missingPrefetch, strategies);
        }
        catch (BaseServerResponseException e) {
            throw new PreconditionFailedException(Msg.code((int)2385) + "Unable to fetch missing resource(s) with key(s) " + missingPrefetch + " for CDS Hooks service " + serviceId + ": " + e.getMessage());
        }
    }

    private void fetchMissingPrefetchElements(CdsServiceRequestJson theCdsServiceRequestJson, CdsServiceJson theServiceSpec, Set<String> theMissingPrefetch, Set<CdsResolutionStrategyEnum> theStrategies) {
        for (String key : theMissingPrefetch) {
            IBaseResource resource;
            String template = theServiceSpec.getPrefetch().get(key);
            CdsResolutionStrategyEnum source = theServiceSpec.getSource().get(key);
            if (!theStrategies.contains((Object)source)) {
                throw new PreconditionFailedException(Msg.code((int)2386) + "Unable to fetch missing resource(s) with source " + source);
            }
            if (source == CdsResolutionStrategyEnum.NONE) {
                if (theStrategies.contains((Object)CdsResolutionStrategyEnum.FHIR_CLIENT)) {
                    source = CdsResolutionStrategyEnum.FHIR_CLIENT;
                } else if (theStrategies.contains((Object)CdsResolutionStrategyEnum.SERVICE)) {
                    source = CdsResolutionStrategyEnum.SERVICE;
                } else if (theStrategies.contains((Object)CdsResolutionStrategyEnum.DAO)) {
                    source = CdsResolutionStrategyEnum.DAO;
                } else {
                    throw new PreconditionFailedException(Msg.code((int)2387) + "Unable to fetch missing resource(s) with source " + source);
                }
            }
            if (source == CdsResolutionStrategyEnum.SERVICE) continue;
            String url = PrefetchTemplateUtil.substituteTemplate(template, theCdsServiceRequestJson.getContext(), this.myResourcePrefetchDao.getFhirContext());
            ourLog.info("missing: {}.  Fetching with {}", theMissingPrefetch, (Object)url);
            if (source == CdsResolutionStrategyEnum.FHIR_CLIENT) {
                resource = this.myResourcePrefetchFhirClient.resourceFromUrl(theCdsServiceRequestJson, url);
            } else if (source == CdsResolutionStrategyEnum.DAO) {
                resource = this.getResourceFromDaoWithPermissionCheck(url);
            } else {
                throw new IllegalStateException(Msg.code((int)2388) + "Unexpected strategy " + theStrategies);
            }
            theCdsServiceRequestJson.addPrefetch(key, resource);
        }
    }

    private IBaseResource getResourceFromDaoWithPermissionCheck(String theUrl) {
        IBaseResource resource = this.myResourcePrefetchDao.resourceFromUrl(theUrl);
        this.myCdsHooksDaoAuthorizationSvc.authorizePreShow(resource);
        return resource;
    }

    public Set<String> findMissingPrefetch(CdsServiceJson theServiceSpec, CdsServiceRequestJson theCdsServiceRequestJson) {
        Set<String> expectedPrefetchKeys = theServiceSpec.getPrefetch().keySet();
        Set<String> actualPrefetchKeys = theCdsServiceRequestJson.getPrefetchKeys();
        HashSet<String> retval = new HashSet<String>(expectedPrefetchKeys);
        retval.removeAll(actualPrefetchKeys);
        return retval;
    }
}

