/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.prefetch;

import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.hapi.fhir.cdshooks.api.CdsResolutionStrategyEnum;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsServiceMethod;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceRequestJson;
import java.util.HashSet;
import java.util.Set;

public class CdsResolutionStrategySvc {
    private final DaoRegistry myDaoRegistry;

    public CdsResolutionStrategySvc(DaoRegistry theDaoRegistry) {
        this.myDaoRegistry = theDaoRegistry;
    }

    public Set<CdsResolutionStrategyEnum> determineResolutionStrategy(ICdsServiceMethod theMethod, CdsServiceRequestJson theRequest) {
        HashSet<CdsResolutionStrategyEnum> strategies = new HashSet<CdsResolutionStrategyEnum>();
        strategies.add(CdsResolutionStrategyEnum.NONE);
        if (theRequest.getFhirServer() != null) {
            strategies.add(CdsResolutionStrategyEnum.SERVICE);
            if (theMethod.isAllowAutoFhirClientPrefetch()) {
                strategies.add(CdsResolutionStrategyEnum.FHIR_CLIENT);
            }
        }
        if (this.myDaoRegistry != null) {
            strategies.add(CdsResolutionStrategyEnum.DAO);
        }
        return strategies;
    }
}

