/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.api.json;

import ca.uhn.fhir.rest.api.server.cdshooks.BaseCdsServiceJson;
import ca.uhn.hapi.fhir.cdshooks.api.CdsPrefetchFailureMode;
import ca.uhn.hapi.fhir.cdshooks.api.CdsResolutionStrategyEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class CdsServiceJson
extends BaseCdsServiceJson {
    public static final String HOOK = "hook";
    public static final String TITLE = "title";
    public static final String DESCRIPTION = "description";
    public static final String ID = "id";
    public static final String PREFETCH = "prefetch";
    @JsonProperty(value="hook", required=true)
    String myHook;
    @JsonProperty(value="title")
    String myTitle;
    @JsonProperty(value="description", required=true)
    String myDescription;
    @JsonProperty(value="id", required=true)
    String myId;
    @JsonProperty(value="prefetch")
    private Map<String, String> myPrefetch;
    private Map<String, CdsResolutionStrategyEnum> mySource;
    private Map<String, CdsPrefetchFailureMode> myPrefetchFailureModes;

    public String getHook() {
        return this.myHook;
    }

    public CdsServiceJson setHook(String theHook) {
        this.myHook = theHook;
        return this;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public CdsServiceJson setTitle(String theTitle) {
        this.myTitle = theTitle;
        return this;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public CdsServiceJson setDescription(String theDescription) {
        this.myDescription = theDescription;
        return this;
    }

    public String getId() {
        return this.myId;
    }

    public CdsServiceJson setId(String theId) {
        this.myId = theId;
        return this;
    }

    public void addPrefetch(String theKey, String theQuery) {
        if (this.myPrefetch == null) {
            this.myPrefetch = new LinkedHashMap<String, String>();
        }
        this.myPrefetch.put(theKey, theQuery);
    }

    public Map<String, String> getPrefetch() {
        if (this.myPrefetch == null) {
            this.myPrefetch = new LinkedHashMap<String, String>();
        }
        return Collections.unmodifiableMap(this.myPrefetch);
    }

    public void addSource(String theKey, CdsResolutionStrategyEnum theSource) {
        if (this.mySource == null) {
            this.mySource = new LinkedHashMap<String, CdsResolutionStrategyEnum>();
        }
        this.mySource.put(theKey, theSource);
    }

    public Map<String, CdsResolutionStrategyEnum> getSource() {
        if (this.mySource == null) {
            this.mySource = new LinkedHashMap<String, CdsResolutionStrategyEnum>();
        }
        return Collections.unmodifiableMap(this.mySource);
    }

    public void addPrefetchFailureMode(String theKey, CdsPrefetchFailureMode theFailureMode) {
        if (this.myPrefetchFailureModes == null) {
            this.myPrefetchFailureModes = new LinkedHashMap<String, CdsPrefetchFailureMode>();
        }
        this.myPrefetchFailureModes.put(theKey, theFailureMode);
    }

    public CdsPrefetchFailureMode getPrefetchFailureMode(String theKey) {
        if (this.myPrefetchFailureModes == null) {
            this.myPrefetchFailureModes = new LinkedHashMap<String, CdsPrefetchFailureMode>();
        }
        return this.myPrefetchFailureModes.getOrDefault(theKey, CdsPrefetchFailureMode.FAIL);
    }
}

