/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.module;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.server.cdshooks.CdsServiceRequestContextJson;
import ca.uhn.fhir.serializer.FhirResourceDeserializer;
import ca.uhn.fhir.serializer.FhirResourceSerializer;
import ca.uhn.hapi.fhir.cdshooks.serializer.CdsServiceRequestContextDeserializer;
import ca.uhn.hapi.fhir.cdshooks.serializer.CdsServiceRequestContextSerializer;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class CdsHooksObjectMapperFactory
extends ObjectMapper {
    private final FhirContext myFhirContext;

    public CdsHooksObjectMapperFactory(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    public ObjectMapper newMapper() {
        Jackson2ObjectMapperBuilder b = new Jackson2ObjectMapperBuilder();
        b.indentOutput(true);
        ObjectMapper retval = b.build();
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new FhirResourceSerializer(this.myFhirContext));
        module.addSerializer((JsonSerializer)new CdsServiceRequestContextSerializer(this.myFhirContext, retval));
        module.addDeserializer(IBaseResource.class, (JsonDeserializer)new FhirResourceDeserializer(this.myFhirContext));
        module.addDeserializer(CdsServiceRequestContextJson.class, (JsonDeserializer)new CdsServiceRequestContextDeserializer(this.myFhirContext, retval));
        retval.registerModule((Module)module);
        return retval;
    }
}

