/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.serializer;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.server.cdshooks.CdsServiceRequestContextJson;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class CdsServiceRequestContextSerializer
extends StdSerializer<CdsServiceRequestContextJson> {
    private final IParser myParser;
    private final ObjectMapper myObjectMapper;

    public CdsServiceRequestContextSerializer(FhirContext theFhirContext, ObjectMapper theObjectMapper) {
        super(CdsServiceRequestContextJson.class);
        this.myParser = theFhirContext.newJsonParser().setPrettyPrint(true);
        this.myObjectMapper = theObjectMapper;
    }

    public void serialize(CdsServiceRequestContextJson theContext, JsonGenerator theJsonGenerator, SerializerProvider theProvider) throws IOException {
        theJsonGenerator.writeStartObject();
        for (String key : theContext.getKeys()) {
            String json;
            theJsonGenerator.writeFieldName(key);
            Object value = theContext.get(key);
            if (value instanceof IBaseResource) {
                IBaseResource resource = (IBaseResource)value;
                json = this.myParser.encodeResourceToString(resource);
            } else {
                json = this.myObjectMapper.writeValueAsString(value);
            }
            theJsonGenerator.writeRawValue(json);
        }
        theJsonGenerator.writeEndObject();
    }
}

