/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.serializer;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.server.cdshooks.CdsHooksExtension;
import ca.uhn.fhir.rest.api.server.cdshooks.CdsServiceRequestContextJson;
import ca.uhn.fhir.rest.api.server.cdshooks.CdsServiceRequestJson;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceJson;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class CdsServiceRequestJsonDeserializer {
    private final ObjectMapper myObjectMapper;
    private final FhirContext myFhirContext;
    private final IParser myParser;

    public CdsServiceRequestJsonDeserializer(@Nonnull FhirContext theFhirContext, @Nonnull ObjectMapper theObjectMapper) {
        this.myFhirContext = theFhirContext;
        this.myParser = this.myFhirContext.newJsonParser().setPrettyPrint(true);
        this.myObjectMapper = theObjectMapper;
    }

    public CdsServiceRequestJson deserialize(@Nonnull CdsServiceJson theCdsServiceJson, @Nonnull Object theCdsServiceRequestJson) {
        JsonNode cdsServiceRequestJsonNode = (JsonNode)this.myObjectMapper.convertValue(theCdsServiceRequestJson, JsonNode.class);
        JsonNode contextNode = cdsServiceRequestJsonNode.get("context");
        this.validateHookInstance(cdsServiceRequestJsonNode.get("hookInstance"));
        this.validateHook(cdsServiceRequestJsonNode.get("hook"));
        this.validateContext(contextNode);
        try {
            JsonNode extensionNode = cdsServiceRequestJsonNode.get("extension");
            CdsServiceRequestJson cdsServiceRequestJson = (CdsServiceRequestJson)this.myObjectMapper.convertValue((Object)cdsServiceRequestJsonNode, CdsServiceRequestJson.class);
            LinkedHashMap map = (LinkedHashMap)this.myObjectMapper.readValue(contextNode.toString(), LinkedHashMap.class);
            cdsServiceRequestJson.setContext(this.deserializeContext(map));
            if (extensionNode != null) {
                CdsHooksExtension myRequestExtension = this.deserializeExtension(theCdsServiceJson, extensionNode.toString());
                cdsServiceRequestJson.setExtension(myRequestExtension);
            }
            return cdsServiceRequestJson;
        }
        catch (JsonProcessingException | IllegalArgumentException theEx) {
            throw new InvalidRequestException(Msg.code((int)2551) + "Invalid CdsServiceRequest received. " + String.valueOf(theEx));
        }
    }

    CdsServiceRequestContextJson deserializeContext(LinkedHashMap<String, Object> theMap) throws JsonProcessingException {
        CdsServiceRequestContextJson cdsServiceRequestContextJson = new CdsServiceRequestContextJson();
        for (Map.Entry<String, Object> entry : theMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof LinkedHashMap) {
                String json = this.myObjectMapper.writeValueAsString(value);
                IBaseResource resource = this.myParser.parseResource(json);
                cdsServiceRequestContextJson.put(key, (Object)resource);
                continue;
            }
            cdsServiceRequestContextJson.put(key, value);
        }
        return cdsServiceRequestContextJson;
    }

    private CdsHooksExtension deserializeExtension(@Nonnull CdsServiceJson theCdsServiceJson, @Nonnull String theExtension) throws JsonProcessingException {
        Class extensionClass = theCdsServiceJson.getExtensionClass();
        if (extensionClass == null) {
            return null;
        }
        return (CdsHooksExtension)this.myObjectMapper.readValue(theExtension, extensionClass);
    }

    private void validateHook(JsonNode hookIdNode) {
        if (hookIdNode == null) {
            throw new InvalidRequestException(Msg.code((int)2549) + "hook cannot be null for a CdsServiceRequest.");
        }
    }

    private void validateHookInstance(JsonNode hookInstanceNode) {
        if (hookInstanceNode == null) {
            throw new InvalidRequestException(Msg.code((int)2548) + "hookInstance cannot be null for a CdsServiceRequest.");
        }
    }

    private void validateContext(JsonNode requestContextNode) {
        if (requestContextNode == null) {
            throw new InvalidRequestException(Msg.code((int)2550) + "context cannot be null for a CdsServiceRequest.");
        }
    }
}

