/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc;

import ca.uhn.fhir.rest.api.server.cdshooks.CdsServiceRequestJson;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsMethod;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsServiceMethod;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServicesJson;
import ca.uhn.hapi.fhir.cdshooks.svc.CdsDynamicPrefetchableServiceMethod;
import ca.uhn.hapi.fhir.cdshooks.svc.CdsFeedbackMethod;
import ca.uhn.hapi.fhir.cdshooks.svc.CdsServiceMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsServiceCache {
    static final Logger ourLog = LoggerFactory.getLogger(CdsServiceCache.class);
    final Map<String, ICdsMethod> myServiceMap = new LinkedHashMap<String, ICdsMethod>();
    final Map<String, ICdsMethod> myFeedbackMap = new LinkedHashMap<String, ICdsMethod>();
    final CdsServicesJson myCdsServiceJson = new CdsServicesJson();
    final Map<String, Set<String>> myGroups = new LinkedHashMap<String, Set<String>>();

    public void registerService(String theServiceId, Object theServiceBean, Method theMethod, CdsServiceJson theCdsServiceJson, boolean theAllowAutoFhirClientPrefetch) {
        CdsServiceMethod cdsServiceMethod = new CdsServiceMethod(theCdsServiceJson, theServiceBean, theMethod, theAllowAutoFhirClientPrefetch);
        this.myServiceMap.put(theServiceId, cdsServiceMethod);
        this.myCdsServiceJson.addService(theCdsServiceJson);
    }

    public void registerDynamicService(String theServiceId, Function<CdsServiceRequestJson, CdsServiceResponseJson> theMethod, CdsServiceJson theCdsServiceJson, boolean theAllowAutoFhirClientPrefetch, String theServiceGroupId) {
        if (!this.isCdsServiceAlreadyRegistered(theServiceId, theServiceGroupId)) {
            CdsDynamicPrefetchableServiceMethod cdsDynamicPrefetchableServiceMethod = new CdsDynamicPrefetchableServiceMethod(theCdsServiceJson, theMethod, theAllowAutoFhirClientPrefetch);
            this.myServiceMap.put(theServiceId, cdsDynamicPrefetchableServiceMethod);
            this.myGroups.computeIfAbsent(theServiceGroupId, k -> new HashSet()).add(theServiceId);
            this.myCdsServiceJson.addService(theCdsServiceJson);
        }
    }

    public void registerFeedback(String theServiceId, Object theServiceBean, Method theMethod) {
        CdsFeedbackMethod cdsFeedbackMethod = new CdsFeedbackMethod(theServiceBean, theMethod);
        this.myFeedbackMap.put(theServiceId, cdsFeedbackMethod);
    }

    public ICdsMethod getServiceMethod(String theId) {
        return this.myServiceMap.get(theId);
    }

    public ICdsMethod getFeedbackMethod(String theId) {
        return this.myFeedbackMap.get(theId);
    }

    public CdsServicesJson getCdsServicesJson() {
        return this.myCdsServiceJson;
    }

    public ICdsMethod unregisterServiceMethod(String theServiceId, String theServiceGroupId) {
        if (this.myServiceMap.containsKey(theServiceId)) {
            ICdsMethod serviceMethod = this.myServiceMap.get(theServiceId);
            this.myServiceMap.remove(theServiceId);
            this.myGroups.computeIfAbsent(theServiceGroupId, k -> new HashSet()).remove(theServiceId);
            if (this.myGroups.get(theServiceGroupId).isEmpty()) {
                this.myGroups.remove(theServiceGroupId);
            }
            if (serviceMethod instanceof ICdsServiceMethod) {
                this.myCdsServiceJson.removeService(((ICdsServiceMethod)serviceMethod).getCdsServiceJson());
            }
            return serviceMethod;
        }
        ourLog.error("CDS service with serviceId: {} for serviceGroupId: {}, is not registered. Nothing to remove!", (Object)theServiceId, (Object)theServiceGroupId);
        return null;
    }

    public void unregisterServices(String theServiceGroupId) {
        if (this.myGroups.containsKey(theServiceGroupId)) {
            new ArrayList<String>((Collection)this.myGroups.get(theServiceGroupId)).forEach(serviceId -> this.unregisterServiceMethod((String)serviceId, theServiceGroupId));
        } else {
            ourLog.error("CDS services for serviceGroupId: {}, are not registered. Nothing to remove!", (Object)theServiceGroupId);
        }
    }

    private boolean isCdsServiceAlreadyRegistered(String theServiceId, String theServiceGroupId) {
        boolean result = this.myServiceMap.containsKey(theServiceId);
        if (result) {
            ourLog.error("CDS service with serviceId: {} for serviceGroupId: {}, already exists. It will not be overwritten!", (Object)theServiceId, (Object)theServiceGroupId);
        }
        return result;
    }

    CdsServiceJson getCdsServiceJson(String theString) {
        return this.myCdsServiceJson.getServices().stream().filter(x -> x.getId().equals(theString)).findFirst().orElse(null);
    }
}

