/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.api.server.cdshooks.CdsHooksExtension;
import ca.uhn.fhir.rest.api.server.cdshooks.CdsServiceRequestJson;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.hapi.fhir.cdshooks.api.CDSHooksVersion;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsMethod;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsServiceMethod;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsServiceRegistry;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceFeedbackJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceResponseJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServicesJson;
import ca.uhn.hapi.fhir.cdshooks.serializer.CdsServiceRequestJsonDeserializer;
import ca.uhn.hapi.fhir.cdshooks.svc.CdsHooksContextBooter;
import ca.uhn.hapi.fhir.cdshooks.svc.CdsServiceCache;
import ca.uhn.hapi.fhir.cdshooks.svc.prefetch.CdsPrefetchSvc;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.function.Function;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsServiceRegistryImpl
implements ICdsServiceRegistry {
    private static final Logger ourLog = LoggerFactory.getLogger(CdsServiceRegistryImpl.class);
    private final CdsServiceRequestJsonDeserializer myCdsServiceRequestJsonDeserializer;
    private CdsServiceCache myServiceCache;
    private final CdsHooksContextBooter myCdsHooksContextBooter;
    private final CdsPrefetchSvc myCdsPrefetchSvc;
    private final ObjectMapper myObjectMapper;
    private final CDSHooksVersion myCdsHooksVersion;

    public CdsServiceRegistryImpl(CdsHooksContextBooter theCdsHooksContextBooter, CdsPrefetchSvc theCdsPrefetchSvc, ObjectMapper theObjectMapper, CdsServiceRequestJsonDeserializer theCdsServiceRequestJsonDeserializer) {
        this(theCdsHooksContextBooter, theCdsPrefetchSvc, theObjectMapper, theCdsServiceRequestJsonDeserializer, CDSHooksVersion.DEFAULT);
    }

    public CdsServiceRegistryImpl(CdsHooksContextBooter theCdsHooksContextBooter, CdsPrefetchSvc theCdsPrefetchSvc, ObjectMapper theObjectMapper, CdsServiceRequestJsonDeserializer theCdsServiceRequestJsonDeserializer, CDSHooksVersion theCDSHooksVersion) {
        this.myCdsHooksContextBooter = theCdsHooksContextBooter;
        this.myCdsPrefetchSvc = theCdsPrefetchSvc;
        this.myObjectMapper = theObjectMapper;
        this.myCdsServiceRequestJsonDeserializer = theCdsServiceRequestJsonDeserializer;
        this.myCdsHooksVersion = theCDSHooksVersion;
    }

    @PostConstruct
    public void init() {
        this.myServiceCache = this.myCdsHooksContextBooter.buildCdsServiceCache();
    }

    @Override
    public CdsServicesJson getCdsServicesJson() {
        return this.myServiceCache.getCdsServicesJson();
    }

    @Override
    public CdsServiceResponseJson callService(String theServiceId, Object theCdsServiceRequestJson) {
        CdsServiceJson cdsServiceJson = this.getCdsServiceJson(theServiceId);
        CdsServiceRequestJson deserializedRequest = this.myCdsServiceRequestJsonDeserializer.deserialize(cdsServiceJson, theCdsServiceRequestJson);
        this.validateHookRequestFhirServer(deserializedRequest);
        ICdsServiceMethod serviceMethod = (ICdsServiceMethod)this.getCdsServiceMethodOrThrowException(theServiceId);
        this.myCdsPrefetchSvc.augmentRequest(deserializedRequest, serviceMethod);
        Object response = serviceMethod.invoke(this.myObjectMapper, (IModelJson)deserializedRequest, theServiceId);
        return this.encodeServiceResponse(theServiceId, response);
    }

    @Override
    public CdsServiceFeedbackJson callFeedback(String theServiceId, CdsServiceFeedbackJson theCdsServiceFeedbackJson) {
        ICdsMethod feedbackMethod = this.getCdsFeedbackMethodOrThrowException(theServiceId);
        Object response = feedbackMethod.invoke(this.myObjectMapper, theCdsServiceFeedbackJson, theServiceId);
        return this.encodeFeedbackResponse(theServiceId, response);
    }

    @Override
    public void registerService(String theServiceId, Function<CdsServiceRequestJson, CdsServiceResponseJson> theServiceFunction, CdsServiceJson theCdsServiceJson, boolean theAllowAutoFhirClientPrefetch, String theServiceGroupId) {
        if (theCdsServiceJson.getExtensionClass() == null) {
            theCdsServiceJson.setExtensionClass(CdsHooksExtension.class);
        }
        this.myServiceCache.registerDynamicService(theServiceId, theServiceFunction, theCdsServiceJson, theAllowAutoFhirClientPrefetch, theServiceGroupId);
    }

    @Override
    public void unregisterService(@Nonnull String theServiceId, String theServiceGroupId) {
        Validate.notNull((Object)theServiceId, (String)"CDS Hook Service Id cannot be null", (Object[])new Object[0]);
        ICdsMethod activeService = this.myServiceCache.unregisterServiceMethod(theServiceId, theServiceGroupId);
        if (activeService != null) {
            ourLog.info("Unregistered active service {}", (Object)theServiceId);
        }
    }

    @Override
    public void unregisterServices(@Nonnull String theServiceGroupId) {
        Validate.notNull((Object)theServiceGroupId, (String)"CDS Hook Service Group Id cannot be null", (Object[])new Object[0]);
        this.myServiceCache.unregisterServices(theServiceGroupId);
    }

    @Override
    public CdsServiceJson getCdsServiceJson(String theServiceId) {
        CdsServiceJson cdsServiceJson = this.myServiceCache.getCdsServiceJson(theServiceId);
        if (cdsServiceJson == null) {
            throw new IllegalArgumentException(Msg.code((int)2536) + "No service with " + theServiceId + " is registered.");
        }
        return cdsServiceJson;
    }

    @Nonnull
    private ICdsMethod getCdsServiceMethodOrThrowException(String theId) {
        ICdsMethod retval = this.myServiceCache.getServiceMethod(theId);
        if (retval == null) {
            throw new ResourceNotFoundException(Msg.code((int)2391) + "No service with id " + theId + " is registered on this server");
        }
        return retval;
    }

    @Nonnull
    CdsServiceResponseJson encodeServiceResponse(String theServiceId, Object result) {
        if (result instanceof String) {
            return this.buildResponseFromString(theServiceId, result, (String)result);
        }
        return this.buildResponseFromImplementation(theServiceId, result);
    }

    @Nonnull
    private ICdsMethod getCdsFeedbackMethodOrThrowException(String theId) {
        ICdsMethod retval = this.myServiceCache.getFeedbackMethod(theId);
        if (retval == null) {
            throw new ResourceNotFoundException(Msg.code((int)2392) + "No feedback service with id " + theId + " is registered on this server");
        }
        return retval;
    }

    @Nonnull
    CdsServiceFeedbackJson encodeFeedbackResponse(String theServiceId, Object theResponse) {
        if (theResponse instanceof String) {
            return this.buildFeedbackFromString(theServiceId, (String)theResponse);
        }
        return this.buildFeedbackFromImplementation(theServiceId, theResponse);
    }

    private CdsServiceResponseJson buildResponseFromImplementation(String theServiceId, Object theResult) {
        try {
            return (CdsServiceResponseJson)theResult;
        }
        catch (ClassCastException e) {
            throw new ConfigurationException(Msg.code((int)2389) + "Failed to cast Cds service response to CdsServiceResponseJson when calling CDS Hook Service " + theServiceId + ". The type " + theResult.getClass().getName() + " cannot be casted to CdsServiceResponseJson", (Throwable)e);
        }
    }

    private CdsServiceResponseJson buildResponseFromString(String theServiceId, Object theResult, String theJson) {
        try {
            return (CdsServiceResponseJson)this.myObjectMapper.readValue(theJson, CdsServiceResponseJson.class);
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException(Msg.code((int)2390) + "Failed to json deserialize Cds service response of type " + theResult.getClass().getName() + " when calling CDS Hook Service " + theServiceId + ".  Json: " + theJson, (Throwable)e);
        }
    }

    private CdsServiceFeedbackJson buildFeedbackFromImplementation(String theServiceId, Object theResponse) {
        try {
            return (CdsServiceFeedbackJson)theResponse;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(Msg.code((int)2537) + "Failed to cast feedback response CdsServiceFeedbackJson for service " + theServiceId + ". " + e.getMessage());
        }
    }

    private CdsServiceFeedbackJson buildFeedbackFromString(String theServiceId, String theResponse) {
        try {
            return (CdsServiceFeedbackJson)this.myObjectMapper.readValue(theResponse, CdsServiceFeedbackJson.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(Msg.code((int)2538) + "Failed to serialize json Cds Feedback response for service " + theServiceId + ". " + e.getMessage());
        }
    }

    @VisibleForTesting
    void setServiceCache(CdsServiceCache theCdsServiceCache) {
        this.myServiceCache = theCdsServiceCache;
    }

    private void validateHookRequestFhirServer(CdsServiceRequestJson theCdsServiceRequestJson) {
        String fhirServer;
        if (this.myCdsHooksVersion != CDSHooksVersion.V_1_1 && (fhirServer = theCdsServiceRequestJson.getFhirServer()) != null && !fhirServer.startsWith("https")) {
            throw new InvalidRequestException(Msg.code((int)2632) + "The scheme for the fhirServer must be https");
        }
    }
}

