/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.prefetch;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.UrlUtil;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.stereotype.Service;

@Service
public class CdsPrefetchDaoSvc {
    public static final int MAX_RESOURCES_IN_BUNDLE = 1024;
    private final DaoRegistry myDaoRegistry;
    private final MatchUrlService myMatchUrlService;
    private final FhirContext myFhirContext;

    public CdsPrefetchDaoSvc(DaoRegistry theDaoRegistry, MatchUrlService theMatchUrlService, FhirContext theFhirContext) {
        this.myDaoRegistry = theDaoRegistry;
        this.myMatchUrlService = theMatchUrlService;
        this.myFhirContext = theFhirContext;
    }

    public IBaseResource resourceFromUrl(String theUrl) {
        UrlUtil.UrlParts parts = UrlUtil.parseUrl((String)theUrl);
        String resourceType = parts.getResourceType();
        if (resourceType == null) {
            throw new InvalidRequestException(Msg.code((int)2380) + "Failed to resolve " + theUrl + ". Url does not start with resource type");
        }
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
        if (dao == null) {
            throw new ConfigurationException(Msg.code((int)2381) + "No dao registered for resource type " + resourceType);
        }
        String resourceId = parts.getResourceId();
        if (resourceId != null) {
            return dao.read((IIdType)new IdDt(resourceType, resourceId));
        }
        String matchUrl = parts.getParams();
        if (matchUrl != null) {
            return this.getBundleFromUrl(resourceType, dao, matchUrl);
        }
        throw new InvalidRequestException(Msg.code((int)2382) + "Unable to translate url " + theUrl + " into a resource or a bundle");
    }

    private IBaseResource getBundleFromUrl(String resourceType, IFhirResourceDao<?> dao, String matchUrl) {
        RuntimeResourceDefinition resourceDef = this.myFhirContext.getResourceDefinition(resourceType);
        SearchParameterMap searchParams = this.myMatchUrlService.translateMatchUrl(matchUrl, resourceDef, new MatchUrlService.Flag[0]);
        searchParams.setLoadSynchronous(true);
        IBundleProvider bundleProvider = dao.search(searchParams);
        IVersionSpecificBundleFactory bundleFactory = this.myFhirContext.newBundleFactory();
        bundleFactory.addResourcesToBundle(bundleProvider.getResources(0, 1024), BundleTypeEnum.SEARCHSET, null, null, null);
        return bundleFactory.getResourceBundle();
    }

    public FhirContext getFhirContext() {
        return this.myFhirContext;
    }
}

