/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.prefetch;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.server.cdshooks.CdsServiceRequestAuthorizationJson;
import ca.uhn.fhir.rest.api.server.cdshooks.CdsServiceRequestJson;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.interceptor.BearerTokenAuthInterceptor;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.BundleBuilder;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.UrlUtil;
import ca.uhn.fhir.util.bundle.SearchBundleEntryParts;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.stereotype.Service;

@Service
public class CdsPrefetchFhirClientSvc {
    private final FhirContext myFhirContext;

    public CdsPrefetchFhirClientSvc(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    public IBaseResource resourceFromUrl(CdsServiceRequestJson theCdsServiceRequestJson, String theUrl) {
        IGenericClient client = this.buildClient(theCdsServiceRequestJson);
        UrlUtil.UrlParts parts = UrlUtil.parseUrl((String)theUrl);
        String resourceType = parts.getResourceType();
        if (StringUtils.isEmpty((CharSequence)resourceType)) {
            throw new InvalidRequestException(Msg.code((int)2383) + "Failed to resolve " + theUrl + ". Url does not start with a resource type.");
        }
        String resourceId = parts.getResourceId();
        String matchUrl = parts.getParams();
        if (resourceId != null) {
            return (IBaseResource)client.read().resource(resourceType).withId(resourceId).execute();
        }
        if (matchUrl != null) {
            return this.collectResourcesFromUrlFollowingNextLinks(client, theUrl);
        }
        throw new InvalidRequestException(Msg.code((int)2384) + "Unable to translate url " + theUrl + " into a resource or a bundle.");
    }

    private IBaseBundle collectResourcesFromUrlFollowingNextLinks(IGenericClient theClient, String theUrl) {
        boolean hasNext;
        IBaseBundle bundle = (IBaseBundle)theClient.search().byUrl(theUrl).execute();
        boolean bl = hasNext = BundleUtil.getLinkUrlOfType((FhirContext)this.myFhirContext, (IBaseBundle)bundle, (String)"next") != null;
        if (!hasNext) {
            return bundle;
        }
        BundleBuilder bundleBuilder = new BundleBuilder(this.myFhirContext);
        bundleBuilder.setType(BundleUtil.getBundleType((FhirContext)this.myFhirContext, (IBaseBundle)bundle));
        this.addAllResourcesOfBundleToBundleBuilder(bundleBuilder, bundle);
        while (hasNext) {
            bundle = (IBaseBundle)theClient.loadPage().next(bundle).execute();
            this.addAllResourcesOfBundleToBundleBuilder(bundleBuilder, bundle);
            hasNext = BundleUtil.getLinkUrlOfType((FhirContext)this.myFhirContext, (IBaseBundle)bundle, (String)"next") != null;
        }
        return bundleBuilder.getBundle();
    }

    private void addAllResourcesOfBundleToBundleBuilder(BundleBuilder theBundleBuilder, IBaseBundle theBundle) {
        List entries = BundleUtil.getSearchBundleEntryParts((FhirContext)this.myFhirContext, (IBaseBundle)theBundle);
        for (SearchBundleEntryParts currentEntry : entries) {
            boolean hasSearchScore;
            IBase newEntry = theBundleBuilder.addEntry();
            theBundleBuilder.addFullUrl(newEntry, currentEntry.getFullUrl());
            theBundleBuilder.addToEntry(newEntry, "resource", (IBase)currentEntry.getResource());
            boolean hasSearchMode = currentEntry.getSearchMode() != null;
            boolean bl = hasSearchScore = currentEntry.getSearchScore() != null;
            if (!hasSearchMode && !hasSearchScore) continue;
            IBaseBackboneElement search = theBundleBuilder.addSearch(newEntry);
            if (hasSearchMode) {
                theBundleBuilder.setSearchField((IBase)search, "mode", currentEntry.getSearchMode().getCode());
            }
            if (!hasSearchScore) continue;
            theBundleBuilder.setSearchField((IBase)search, "score", currentEntry.getSearchScore().toString());
        }
    }

    private IGenericClient buildClient(CdsServiceRequestJson theCdsServiceRequestJson) {
        String fhirServerBase = theCdsServiceRequestJson.getFhirServer();
        CdsServiceRequestAuthorizationJson serviceRequestAuthorization = theCdsServiceRequestJson.getServiceRequestAuthorizationJson();
        IGenericClient client = this.myFhirContext.newRestfulGenericClient(fhirServerBase);
        if (serviceRequestAuthorization != null && serviceRequestAuthorization.getAccessToken() != null) {
            BearerTokenAuthInterceptor authInterceptor = new BearerTokenAuthInterceptor(serviceRequestAuthorization.getAccessToken());
            client.registerInterceptor((Object)authInterceptor);
        }
        return client;
    }
}

