/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.fhir.cdshooks.svc.prefetch;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.cdshooks.CdsServiceRequestJson;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import ca.uhn.hapi.fhir.cdshooks.api.CdsPrefetchFailureMode;
import ca.uhn.hapi.fhir.cdshooks.api.CdsResolutionStrategyEnum;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsHooksDaoAuthorizationSvc;
import ca.uhn.hapi.fhir.cdshooks.api.ICdsServiceMethod;
import ca.uhn.hapi.fhir.cdshooks.api.json.CdsServiceJson;
import ca.uhn.hapi.fhir.cdshooks.api.json.prefetch.CdsHookPrefetchPointcutContextJson;
import ca.uhn.hapi.fhir.cdshooks.svc.prefetch.CdsPrefetchDaoSvc;
import ca.uhn.hapi.fhir.cdshooks.svc.prefetch.CdsPrefetchFhirClientSvc;
import ca.uhn.hapi.fhir.cdshooks.svc.prefetch.CdsResolutionStrategySvc;
import ca.uhn.hapi.fhir.cdshooks.svc.prefetch.PrefetchTemplateUtil;
import jakarta.annotation.Nullable;
import java.util.HashSet;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CdsPrefetchSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(CdsPrefetchSvc.class);
    private final CdsResolutionStrategySvc myCdsResolutionStrategySvc;
    private final CdsPrefetchDaoSvc myResourcePrefetchDao;
    private final CdsPrefetchFhirClientSvc myResourcePrefetchFhirClient;
    private final ICdsHooksDaoAuthorizationSvc myCdsHooksDaoAuthorizationSvc;
    private final FhirContext myFhirContext;
    @Nullable
    private final IInterceptorBroadcaster myInterceptorBroadcaster;

    public CdsPrefetchSvc(CdsResolutionStrategySvc theCdsResolutionStrategySvc, CdsPrefetchDaoSvc theResourcePrefetchDao, CdsPrefetchFhirClientSvc theResourcePrefetchFhirClient, ICdsHooksDaoAuthorizationSvc theCdsHooksDaoAuthorizationSvc, @Nullable IInterceptorBroadcaster theInterceptorBroadcaster) {
        this.myCdsResolutionStrategySvc = theCdsResolutionStrategySvc;
        this.myResourcePrefetchDao = theResourcePrefetchDao;
        this.myResourcePrefetchFhirClient = theResourcePrefetchFhirClient;
        this.myCdsHooksDaoAuthorizationSvc = theCdsHooksDaoAuthorizationSvc;
        this.myFhirContext = theResourcePrefetchDao.getFhirContext();
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
    }

    public void augmentRequest(CdsServiceRequestJson theCdsServiceRequestJson, ICdsServiceMethod theServiceMethod) {
        CdsServiceJson serviceSpec = theServiceMethod.getCdsServiceJson();
        Set<String> missingPrefetch = this.findMissingPrefetch(serviceSpec, theCdsServiceRequestJson);
        this.handleOperationOutcomesSentByCdsClient(serviceSpec, theCdsServiceRequestJson);
        if (missingPrefetch.isEmpty()) {
            return;
        }
        Set<CdsResolutionStrategyEnum> strategies = this.myCdsResolutionStrategySvc.determineResolutionStrategy(theServiceMethod, theCdsServiceRequestJson);
        String serviceId = theServiceMethod.getCdsServiceJson().getId();
        try {
            this.fetchMissingPrefetchElements(theCdsServiceRequestJson, serviceSpec, missingPrefetch, strategies);
        }
        catch (BaseServerResponseException e) {
            throw new PreconditionFailedException(Msg.code((int)2385) + "Unable to fetch missing resource(s) with key(s) " + String.valueOf(missingPrefetch) + " for CDS Hooks service " + serviceId + ": " + e.getMessage());
        }
    }

    private void handleOperationOutcomesSentByCdsClient(CdsServiceJson theServiceSpec, CdsServiceRequestJson theCdsServiceRequestJson) {
        HashSet<String> prefetchKeysToRemove = new HashSet<String>();
        String serviceId = theServiceSpec.getId();
        for (String prefetchKey : theCdsServiceRequestJson.getPrefetchKeys()) {
            IBaseResource resource = theCdsServiceRequestJson.getPrefetch(prefetchKey);
            CdsPrefetchFailureMode failureMode = theServiceSpec.getPrefetchFailureMode(prefetchKey);
            if (!(resource instanceof IBaseOperationOutcome)) continue;
            if (failureMode == CdsPrefetchFailureMode.FAIL) {
                String message = String.format("The CDS service '%s' received an OperationOutcome resource for prefetch key '%s' but the service isn't configured to handle OperationOutcome", serviceId, prefetchKey);
                throw new PreconditionFailedException(Msg.code((int)2635) + message);
            }
            if (failureMode != CdsPrefetchFailureMode.OMIT) continue;
            ourLog.info("The CDS service '{}' received an OperationOutcome for the prefetch key '{}' and the failure mode is set to 'OMIT'. The prefetch key will be removed from the request.", (Object)serviceId, (Object)prefetchKey);
            prefetchKeysToRemove.add(prefetchKey);
        }
        for (String prefetchKey : prefetchKeysToRemove) {
            theCdsServiceRequestJson.removePrefetch(prefetchKey);
        }
    }

    private void fetchMissingPrefetchElements(CdsServiceRequestJson theCdsServiceRequestJson, CdsServiceJson theServiceSpec, Set<String> theMissingPrefetch, Set<CdsResolutionStrategyEnum> theStrategies) {
        for (String key : theMissingPrefetch) {
            String template = theServiceSpec.getPrefetch().get(key);
            CdsResolutionStrategyEnum source = theServiceSpec.getSource().get(key);
            CdsPrefetchFailureMode failureMode = theServiceSpec.getPrefetchFailureMode(key);
            if (!theStrategies.contains((Object)source)) {
                throw new PreconditionFailedException(Msg.code((int)2386) + "Unable to fetch missing resource(s) with source " + String.valueOf((Object)source));
            }
            if (source == CdsResolutionStrategyEnum.NONE) {
                if (theStrategies.contains((Object)CdsResolutionStrategyEnum.FHIR_CLIENT)) {
                    source = CdsResolutionStrategyEnum.FHIR_CLIENT;
                } else if (theStrategies.contains((Object)CdsResolutionStrategyEnum.SERVICE)) {
                    source = CdsResolutionStrategyEnum.SERVICE;
                } else if (theStrategies.contains((Object)CdsResolutionStrategyEnum.DAO)) {
                    source = CdsResolutionStrategyEnum.DAO;
                } else {
                    throw new PreconditionFailedException(Msg.code((int)2387) + "Unable to fetch missing resource(s) with source " + String.valueOf((Object)source));
                }
            }
            if (source == CdsResolutionStrategyEnum.SERVICE) continue;
            String url = PrefetchTemplateUtil.substituteTemplate(template, theCdsServiceRequestJson.getContext(), this.myFhirContext);
            ourLog.info("missing: {}.  Fetching with {}", theMissingPrefetch, (Object)url);
            CdsHookPrefetchPointcutContextJson cdsHookPrefetchPointcutContext = new CdsHookPrefetchPointcutContextJson();
            cdsHookPrefetchPointcutContext.setTemplate(template);
            cdsHookPrefetchPointcutContext.setQuery(url);
            cdsHookPrefetchPointcutContext.setCdsResolutionStrategy(source);
            IBaseResource resource = this.prefetchResource(theCdsServiceRequestJson, key, url, source, failureMode, cdsHookPrefetchPointcutContext);
            if (resource == null) continue;
            theCdsServiceRequestJson.addPrefetch(key, resource);
        }
    }

    @Nullable
    private IBaseResource prefetchResource(CdsServiceRequestJson theCdsServiceRequestJson, String thePrefetchKey, String theUrl, CdsResolutionStrategyEnum theStrategy, CdsPrefetchFailureMode theFailureMode, CdsHookPrefetchPointcutContextJson theCdsHookPrefetchPointcutContext) {
        IBaseResource resource;
        this.callCdsPrefetchRequestHooks(theCdsHookPrefetchPointcutContext, theCdsServiceRequestJson);
        boolean prefetchCallSucceeded = false;
        try {
            if (theStrategy == CdsResolutionStrategyEnum.FHIR_CLIENT) {
                resource = this.myResourcePrefetchFhirClient.resourceFromUrl(theCdsServiceRequestJson, theUrl);
            } else if (theStrategy == CdsResolutionStrategyEnum.DAO) {
                resource = this.getResourceFromDaoWithPermissionCheck(theUrl);
            } else {
                throw new IllegalStateException(Msg.code((int)2675) + "Unexpected strategy: " + String.valueOf((Object)theStrategy));
            }
            prefetchCallSucceeded = true;
        }
        catch (Exception e) {
            this.callCdsPrefetchFailedHooks(theCdsHookPrefetchPointcutContext, theCdsServiceRequestJson, e);
            switch (theFailureMode) {
                case OMIT: {
                    ourLog.info("The prefetch failed for the prefetch key '{}', with the exception message: '{}'. The failure mode for the prefetch key is set to 'OMIT'. The prefetch key will be omitted from the request.", (Object)thePrefetchKey, (Object)e.getMessage());
                    resource = null;
                    break;
                }
                case OPERATION_OUTCOME: {
                    resource = this.extractOrCreateOperationOutcomeFromException(e);
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
        if (prefetchCallSucceeded) {
            this.callCdsPrefetchResponseHooks(theCdsHookPrefetchPointcutContext, theCdsServiceRequestJson, resource);
        }
        return resource;
    }

    private IBaseOperationOutcome extractOrCreateOperationOutcomeFromException(Exception e) {
        IBaseOperationOutcome oo = null;
        if (e instanceof BaseServerResponseException) {
            BaseServerResponseException serverException = (BaseServerResponseException)((Object)e);
            oo = serverException.getOperationOutcome();
        }
        if (oo == null) {
            oo = OperationOutcomeUtil.newInstance((FhirContext)this.myFhirContext);
            OperationOutcomeUtil.addIssue((FhirContext)this.myFhirContext, (IBaseOperationOutcome)oo, (String)"error", (String)e.getMessage(), null, (String)"exception");
        }
        return oo;
    }

    private IBaseResource getResourceFromDaoWithPermissionCheck(String theUrl) {
        IBaseResource resource = this.myResourcePrefetchDao.resourceFromUrl(theUrl);
        this.myCdsHooksDaoAuthorizationSvc.authorizePreShow(resource);
        return resource;
    }

    public Set<String> findMissingPrefetch(CdsServiceJson theServiceSpec, CdsServiceRequestJson theCdsServiceRequestJson) {
        Set<String> expectedPrefetchKeys = theServiceSpec.getPrefetch().keySet();
        Set actualPrefetchKeys = theCdsServiceRequestJson.getPrefetchKeys();
        HashSet<String> retval = new HashSet<String>(expectedPrefetchKeys);
        retval.removeAll(actualPrefetchKeys);
        return retval;
    }

    private void callCdsPrefetchRequestHooks(CdsHookPrefetchPointcutContextJson theCdsHookPrefetchContext, CdsServiceRequestJson theCdsServiceRequestJson) {
        if (this.myInterceptorBroadcaster != null && this.myInterceptorBroadcaster.hasHooks((IPointcut)Pointcut.CDS_HOOK_PREFETCH_REQUEST)) {
            HookParams params = new HookParams();
            params.add(CdsHookPrefetchPointcutContextJson.class, (Object)theCdsHookPrefetchContext);
            params.add(CdsServiceRequestJson.class, (Object)theCdsServiceRequestJson);
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.CDS_HOOK_PREFETCH_REQUEST, params);
        }
    }

    private void callCdsPrefetchResponseHooks(CdsHookPrefetchPointcutContextJson theCdsHookPrefetchContext, CdsServiceRequestJson theCdsServiceRequestJson, IBaseResource theResource) {
        if (this.myInterceptorBroadcaster != null && this.myInterceptorBroadcaster.hasHooks((IPointcut)Pointcut.CDS_HOOK_PREFETCH_RESPONSE)) {
            HookParams params = new HookParams();
            params.add(CdsHookPrefetchPointcutContextJson.class, (Object)theCdsHookPrefetchContext);
            params.add(CdsServiceRequestJson.class, (Object)theCdsServiceRequestJson);
            params.add(IBaseResource.class, (Object)theResource);
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.CDS_HOOK_PREFETCH_RESPONSE, params);
        }
    }

    private void callCdsPrefetchFailedHooks(CdsHookPrefetchPointcutContextJson theCdsHookPrefetchContext, CdsServiceRequestJson theCdsServiceRequestJson, Exception theException) {
        if (this.myInterceptorBroadcaster != null && this.myInterceptorBroadcaster.hasHooks((IPointcut)Pointcut.CDS_HOOK_PREFETCH_FAILED)) {
            HookParams params = new HookParams();
            params.add(CdsHookPrefetchPointcutContextJson.class, (Object)theCdsHookPrefetchContext);
            params.add(CdsServiceRequestJson.class, (Object)theCdsServiceRequestJson);
            params.add(Exception.class, (Object)theException);
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.CDS_HOOK_PREFETCH_FAILED, params);
        }
    }
}

