/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.rest.server.IncomingRequestAddressStrategy;
import java.net.URI;
import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.ServletServerHttpRequest;

public class ApacheProxyAddressStrategy
extends IncomingRequestAddressStrategy {
    private static final String X_FORWARDED_PREFIX = "x-forwarded-prefix";
    private static final String X_FORWARDED_PROTO = "x-forwarded-proto";
    private static final String X_FORWARDED_HOST = "x-forwarded-host";
    private static final String X_FORWARDED_PORT = "x-forwarded-port";
    private static final Logger LOG = LoggerFactory.getLogger(ApacheProxyAddressStrategy.class);
    private final boolean useHttps;

    public ApacheProxyAddressStrategy(boolean useHttps) {
        this.useHttps = useHttps;
    }

    @Override
    public String determineServerBase(ServletContext servletContext, HttpServletRequest request) {
        String serverBase = super.determineServerBase(servletContext, request);
        ServletServerHttpRequest requestWrapper = new ServletServerHttpRequest(request);
        HttpHeaders headers = requestWrapper.getHeaders();
        Optional forwardedHost = headers.getValuesAsList(X_FORWARDED_HOST).stream().findFirst();
        return forwardedHost.map(s -> this.forwardedServerBase(serverBase, headers, (String)s)).orElse(serverBase);
    }

    private String forwardedServerBase(String originalServerBase, HttpHeaders headers, String forwardedHost) {
        Optional<String> forwardedPrefix = this.getForwardedPrefix(headers);
        LOG.debug("serverBase: {}, forwardedHost: {}, forwardedPrefix: {}", new Object[]{originalServerBase, forwardedHost, forwardedPrefix});
        LOG.debug("request header: {}", (Object)headers);
        String host = this.protocol(headers) + "://" + forwardedHost;
        String hostWithOptionalPort = this.port(headers).map(p -> host + ":" + p).orElse(host);
        String path = forwardedPrefix.orElseGet(() -> this.pathFrom(originalServerBase));
        return ApacheProxyAddressStrategy.joinStringsWith(hostWithOptionalPort, path, "/");
    }

    private Optional<String> port(HttpHeaders headers) {
        return Optional.ofNullable(headers.getFirst(X_FORWARDED_PORT));
    }

    private String pathFrom(String serverBase) {
        String serverBasePath = URI.create(serverBase).getPath();
        return (String)StringUtils.defaultIfBlank((CharSequence)serverBasePath, (CharSequence)"");
    }

    private static String joinStringsWith(String left, String right, String joiner) {
        if (left.endsWith(joiner) && right.startsWith(joiner)) {
            return left + right.substring(1);
        }
        if (left.endsWith(joiner) || right.startsWith(joiner)) {
            return left + right;
        }
        return left + joiner + right;
    }

    private Optional<String> getForwardedPrefix(HttpHeaders headers) {
        return Optional.ofNullable(headers.getFirst(X_FORWARDED_PREFIX));
    }

    private String protocol(HttpHeaders headers) {
        String protocol = headers.getFirst(X_FORWARDED_PROTO);
        if (protocol != null) {
            return protocol;
        }
        return this.useHttps ? "https" : "http";
    }

    public static ApacheProxyAddressStrategy forHttp() {
        return new ApacheProxyAddressStrategy(false);
    }

    public static ApacheProxyAddressStrategy forHttps() {
        return new ApacheProxyAddressStrategy(true);
    }
}

