/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

@Interceptor
public class ServeMediaResourceRawInterceptor {
    public static final String MEDIA_CONTENT_CONTENT_TYPE_OPT = "Media.content.contentType";
    private static final Set<RestOperationTypeEnum> RESPOND_TO_OPERATION_TYPES;

    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE, order=1000)
    public boolean outgoingResponse(RequestDetails theRequestDetails, IBaseResource theResponseObject, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws AuthenticationException {
        if (theResponseObject == null) {
            return true;
        }
        FhirContext context = theRequestDetails.getFhirContext();
        String resourceName = context.getResourceType(theResponseObject);
        if (!"Media".equals(resourceName) || !RESPOND_TO_OPERATION_TYPES.contains(theRequestDetails.getRestOperationType())) {
            return true;
        }
        String contentType = null;
        Optional contentTypeOpt = context.newFluentPath().evaluateFirst((IBase)theResponseObject, MEDIA_CONTENT_CONTENT_TYPE_OPT, IPrimitiveType.class);
        if (contentTypeOpt.isPresent()) {
            contentType = ((IPrimitiveType)contentTypeOpt.get()).getValueAsString();
        }
        IPrimitiveType data = null;
        Optional dataOpt = context.newFluentPath().evaluateFirst((IBase)theResponseObject, "Media.content.data", IPrimitiveType.class);
        if (dataOpt.isPresent()) {
            data = (IPrimitiveType)dataOpt.get();
        }
        if (StringUtils.isBlank((CharSequence)contentType) || data == null) {
            return true;
        }
        RestfulServerUtils.ResponseEncoding responseEncoding = RestfulServerUtils.determineResponseEncodingNoDefault(theRequestDetails, null, contentType);
        if (responseEncoding != null && contentType.equals(responseEncoding.getContentType())) {
            this.returnRawResponse(theRequestDetails, theServletResponse, contentType, (IPrimitiveType<byte[]>)data);
            return false;
        }
        String[] outputParam = theRequestDetails.getParameters().get("_output");
        if (outputParam != null && "data".equals(outputParam[0])) {
            this.returnRawResponse(theRequestDetails, theServletResponse, contentType, (IPrimitiveType<byte[]>)data);
            return false;
        }
        return true;
    }

    private void returnRawResponse(RequestDetails theRequestDetails, HttpServletResponse theServletResponse, String theContentType, IPrimitiveType<byte[]> theData) {
        theServletResponse.setStatus(200);
        if (theRequestDetails.getServer() instanceof RestfulServer) {
            RestfulServer rs = (RestfulServer)theRequestDetails.getServer();
            rs.addHeadersToResponse(theServletResponse);
        }
        theServletResponse.addHeader("Content-Type", theContentType);
        try {
            theServletResponse.getOutputStream().write((byte[])theData.getValue());
            theServletResponse.getOutputStream().close();
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    static {
        HashSet<RestOperationTypeEnum> respondToOperationTypes = new HashSet<RestOperationTypeEnum>();
        respondToOperationTypes.add(RestOperationTypeEnum.READ);
        respondToOperationTypes.add(RestOperationTypeEnum.VREAD);
        RESPOND_TO_OPERATION_TYPES = Collections.unmodifiableSet(respondToOperationTypes);
    }
}

