/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.validation;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@Interceptor
public class ValidationMessageSuppressingInterceptor {
    private List<Pattern> mySuppressPatterns = new ArrayList<Pattern>();

    public ValidationMessageSuppressingInterceptor addMessageSuppressionPatterns(String ... thePatterns) {
        return this.addMessageSuppressionPatterns(Arrays.asList(thePatterns));
    }

    public ValidationMessageSuppressingInterceptor addMessageSuppressionPatterns(List<String> thePatterns) {
        for (String next : thePatterns) {
            if (!StringUtils.isNotBlank((CharSequence)next)) continue;
            Pattern pattern = Pattern.compile(next, 2);
            this.mySuppressPatterns.add(pattern);
        }
        return this;
    }

    @Hook(value=Pointcut.VALIDATION_COMPLETED)
    public ValidationResult handle(ValidationResult theResult) {
        ArrayList<SingleValidationMessage> newMessages = new ArrayList<SingleValidationMessage>(theResult.getMessages().size());
        for (SingleValidationMessage next : theResult.getMessages()) {
            String nextMessage = next.getMessage();
            boolean suppress = false;
            for (Pattern nextSuppressPattern : this.mySuppressPatterns) {
                if (!nextSuppressPattern.matcher(nextMessage).find()) continue;
                suppress = true;
                break;
            }
            if (suppress) continue;
            newMessages.add(next);
        }
        if (newMessages.size() == theResult.getMessages().size()) {
            return null;
        }
        return new ValidationResult(theResult.getContext(), newMessages);
    }
}

