/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.util.BinaryUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ResourceParameter
implements IParameter {
    private final boolean myMethodIsOperationOrPatch;
    private Mode myMode;
    private Class<? extends IBaseResource> myResourceType;

    public ResourceParameter(Class<? extends IBaseResource> theParameterType, Object theProvider, Mode theMode, boolean theMethodIsOperation, boolean theMethodIsPatch) {
        Validate.notNull(theParameterType, (String)"theParameterType can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)theMode), (String)"theMode can not be null", (Object[])new Object[0]);
        this.myResourceType = theParameterType;
        this.myMode = theMode;
        this.myMethodIsOperationOrPatch = theMethodIsOperation || theMethodIsPatch;
        Class<? extends IBaseResource> providerResourceType = null;
        if (theProvider instanceof IResourceProvider) {
            providerResourceType = ((IResourceProvider)theProvider).getResourceType();
        }
        if (Modifier.isAbstract(this.myResourceType.getModifiers()) && providerResourceType != null) {
            this.myResourceType = providerResourceType;
        }
    }

    public Mode getMode() {
        return this.myMode;
    }

    public Class<? extends IBaseResource> getResourceType() {
        return this.myResourceType;
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, BaseMethodBinding<?> theMethodBinding) throws InternalErrorException, InvalidRequestException {
        switch (this.myMode) {
            case BODY: {
                try {
                    return IOUtils.toString((Reader)ResourceParameter.createRequestReader(theRequest));
                }
                catch (IOException e) {
                    throw new InternalErrorException("Failed to load request", (Throwable)e);
                }
            }
            case BODY_BYTE_ARRAY: {
                return theRequest.loadRequestContents();
            }
            case ENCODING: {
                return RestfulServerUtils.determineRequestEncodingNoDefault(theRequest);
            }
        }
        Class<? extends IBaseResource> resourceTypeToParse = this.myResourceType;
        if (this.myMethodIsOperationOrPatch) {
            resourceTypeToParse = null;
        }
        return ResourceParameter.parseResourceFromRequest(theRequest, theMethodBinding, resourceTypeToParse);
    }

    private static Reader createRequestReader(RequestDetails theRequest, Charset charset) {
        return new InputStreamReader((InputStream)new ByteArrayInputStream(theRequest.loadRequestContents()), charset);
    }

    public static Reader createRequestReader(RequestDetails theRequest) {
        return ResourceParameter.createRequestReader(theRequest, ResourceParameter.determineRequestCharset(theRequest));
    }

    public static Charset determineRequestCharset(RequestDetails theRequest) {
        Charset charset = theRequest.getCharset();
        if (charset == null) {
            charset = Charset.forName("UTF-8");
        }
        return charset;
    }

    static <T extends IBaseResource> T loadResourceFromRequest(RequestDetails theRequest, @Nonnull BaseMethodBinding<?> theMethodBinding, Class<T> theResourceType) {
        IBaseResource retVal;
        FhirContext ctx = theRequest.getServer().getFhirContext();
        Charset charset = ResourceParameter.determineRequestCharset(theRequest);
        Reader requestReader = ResourceParameter.createRequestReader(theRequest, charset);
        RestOperationTypeEnum restOperationType = theMethodBinding != null ? theMethodBinding.getRestOperationType() : null;
        EncodingEnum encoding = RestfulServerUtils.determineRequestEncodingNoDefault(theRequest);
        if (encoding == null) {
            String ctValue = theRequest.getHeader("Content-Type");
            if (ctValue != null && ctValue.startsWith("application/x-www-form-urlencoded")) {
                String msg = theRequest.getServer().getFhirContext().getLocalizer().getMessage(ResourceParameter.class, "invalidContentTypeInRequest", new Object[]{ctValue, theMethodBinding.getRestOperationType()});
                throw new InvalidRequestException(msg);
            }
            if (StringUtils.isBlank((CharSequence)ctValue)) {
                String body;
                try {
                    body = IOUtils.toString((Reader)requestReader);
                }
                catch (IOException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                if (StringUtils.isBlank((CharSequence)body)) {
                    return null;
                }
                String msg = ctx.getLocalizer().getMessage(ResourceParameter.class, "noContentTypeInRequest", new Object[]{restOperationType});
                throw new InvalidRequestException(msg);
            }
            String msg = ctx.getLocalizer().getMessage(ResourceParameter.class, "invalidContentTypeInRequest", new Object[]{ctValue, restOperationType});
            throw new InvalidRequestException(msg);
        }
        IParser parser = encoding.newParser(ctx);
        parser.setServerBaseUrl(theRequest.getFhirServerBase());
        try {
            retVal = theResourceType != null ? parser.parseResource(theResourceType, requestReader) : parser.parseResource(requestReader);
        }
        catch (DataFormatException e) {
            String msg = ctx.getLocalizer().getMessage(ResourceParameter.class, "failedToParseRequest", new Object[]{encoding.name(), e.getMessage()});
            throw new InvalidRequestException(msg);
        }
        return (T)retVal;
    }

    static IBaseResource parseResourceFromRequest(RequestDetails theRequest, @Nonnull BaseMethodBinding<?> theMethodBinding, Class<? extends IBaseResource> theResourceType) {
        EncodingEnum requestEncoding;
        String ct;
        if (theRequest.getResource() != null) {
            return theRequest.getResource();
        }
        IBaseResource retVal = null;
        if (theResourceType != null && IBaseBinary.class.isAssignableFrom(theResourceType) && EncodingEnum.forContentTypeStrict((String)(ct = theRequest.getHeader("Content-Type"))) == null) {
            String securityContext;
            FhirContext ctx = theRequest.getServer().getFhirContext();
            IBaseBinary binary = BinaryUtil.newBinary((FhirContext)ctx);
            binary.setId(theRequest.getId());
            binary.setContentType(ct);
            binary.setContent(theRequest.loadRequestContents());
            retVal = binary;
            if (ctx.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3) && StringUtils.isNotBlank((CharSequence)(securityContext = theRequest.getHeader("X-Security-Context")))) {
                BinaryUtil.setSecurityContext((FhirContext)ctx, (IBaseBinary)binary, (String)securityContext);
            }
        }
        boolean isNonFhirPatch = false;
        if (theRequest.getRequestType() == RequestTypeEnum.PATCH && (requestEncoding = RestfulServerUtils.determineRequestEncodingNoDefault(theRequest, true)) == null) {
            isNonFhirPatch = true;
        }
        if (retVal == null && !isNonFhirPatch) {
            retVal = ResourceParameter.loadResourceFromRequest(theRequest, theMethodBinding, theResourceType);
        }
        theRequest.setResource(retVal);
        return retVal;
    }

    public static enum Mode {
        BODY,
        BODY_BYTE_ARRAY,
        ENCODING,
        RESOURCE;

    }
}

