/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IMultiUrlJobSubmitter;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.ParametersUtil;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersInvalidException;

public class MultiUrlProcessor {
    private final FhirContext myFhirContext;
    private final IMultiUrlJobSubmitter myMultiUrlProcessorJobSubmitter;

    public MultiUrlProcessor(FhirContext theFhirContext, IMultiUrlJobSubmitter theMultiUrlProcessorJobSubmitter) {
        this.myMultiUrlProcessorJobSubmitter = theMultiUrlProcessorJobSubmitter;
        this.myFhirContext = theFhirContext;
    }

    public IBaseParameters processUrls(List<String> theUrlsToProcess, Integer theBatchSize, RequestDetails theRequestDetails) {
        try {
            JobExecution jobExecution = this.myMultiUrlProcessorJobSubmitter.submitJob(theBatchSize, theUrlsToProcess, theRequestDetails);
            IBaseParameters retval = ParametersUtil.newInstance((FhirContext)this.myFhirContext);
            ParametersUtil.addParameterToParametersLong((FhirContext)this.myFhirContext, (IBaseParameters)retval, (String)"jobId", (long)jobExecution.getJobId());
            return retval;
        }
        catch (JobParametersInvalidException e) {
            throw new InvalidRequestException("Invalid job parameters: " + e.getMessage(), (Throwable)e);
        }
    }

    @Nullable
    public Integer getBatchSize(IPrimitiveType<BigDecimal> theBatchSize) {
        Integer batchSize = null;
        if (theBatchSize != null && !theBatchSize.isEmpty()) {
            batchSize = ((BigDecimal)theBatchSize.getValue()).intValue();
        }
        return batchSize;
    }
}

