/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IReindexJobSubmitter;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.provider.MultiUrlProcessor;
import ca.uhn.fhir.util.ParametersUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersInvalidException;

public class ReindexProvider {
    private final FhirContext myFhirContext;
    private final IReindexJobSubmitter myReindexJobSubmitter;
    private final MultiUrlProcessor myMultiUrlProcessor;

    public ReindexProvider(FhirContext theFhirContext, IReindexJobSubmitter theReindexJobSubmitter) {
        this.myFhirContext = theFhirContext;
        this.myMultiUrlProcessor = new MultiUrlProcessor(theFhirContext, theReindexJobSubmitter);
        this.myReindexJobSubmitter = theReindexJobSubmitter;
    }

    @Operation(name="$reindex", idempotent=false)
    public IBaseParameters Reindex(@OperationParam(name="url", typeName="string", min=0, max=1) List<IPrimitiveType<String>> theUrlsToReindex, @OperationParam(name="batchSize", typeName="decimal", min=0, max=1) IPrimitiveType<BigDecimal> theBatchSize, @OperationParam(name="everything", typeName="boolean", min=0, max=1) IPrimitiveType<Boolean> theEverything, RequestDetails theRequestDetails) {
        boolean everything = theEverything != null && (Boolean)theEverything.getValue() != false;
        Integer batchSize = this.myMultiUrlProcessor.getBatchSize(theBatchSize);
        if (everything) {
            return this.processEverything(batchSize, theRequestDetails);
        }
        if (theUrlsToReindex != null && !theUrlsToReindex.isEmpty()) {
            List<String> urls = theUrlsToReindex.stream().map(IPrimitiveType::getValue).collect(Collectors.toList());
            return this.myMultiUrlProcessor.processUrls(urls, batchSize, theRequestDetails);
        }
        throw new InvalidRequestException("$reindex must specify either everything=true or provide at least one value for url");
    }

    private IBaseParameters processEverything(Integer theBatchSize, RequestDetails theRequestDetails) {
        try {
            JobExecution jobExecution = this.myReindexJobSubmitter.submitEverythingJob(theBatchSize, theRequestDetails);
            IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.myFhirContext);
            ParametersUtil.addParameterToParametersLong((FhirContext)this.myFhirContext, (IBaseParameters)retVal, (String)"jobId", (long)jobExecution.getJobId());
            return retVal;
        }
        catch (JobParametersInvalidException e) {
            throw new InvalidRequestException("Invalid job parameters: " + e.getMessage(), (Throwable)e);
        }
    }
}

