/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BanUnsupportedHttpMethodsInterceptor
extends InterceptorAdapter {
    private Set<RequestTypeEnum> myAllowedMethods = new HashSet<RequestTypeEnum>();

    public BanUnsupportedHttpMethodsInterceptor() {
        this.myAllowedMethods.add(RequestTypeEnum.GET);
        this.myAllowedMethods.add(RequestTypeEnum.OPTIONS);
        this.myAllowedMethods.add(RequestTypeEnum.DELETE);
        this.myAllowedMethods.add(RequestTypeEnum.PUT);
        this.myAllowedMethods.add(RequestTypeEnum.POST);
        this.myAllowedMethods.add(RequestTypeEnum.PATCH);
        this.myAllowedMethods.add(RequestTypeEnum.HEAD);
    }

    @Override
    public boolean incomingRequestPreProcessed(HttpServletRequest theRequest, HttpServletResponse theResponse) {
        RequestTypeEnum requestType = RequestTypeEnum.valueOf((String)theRequest.getMethod());
        if (this.myAllowedMethods.contains(requestType)) {
            return true;
        }
        throw new MethodNotAllowedException(Msg.code((int)329) + "Method not supported: " + theRequest.getMethod());
    }
}

