/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.OperationMethodBinding;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class InteractionBlockingInterceptor {
    public static final Set<RestOperationTypeEnum> ALLOWED_OP_TYPES;
    private static final Logger ourLog;
    private final Set<String> myAllowedKeys;

    private InteractionBlockingInterceptor(@Nonnull Builder theBuilder) {
        this.myAllowedKeys = theBuilder.myAllowedKeys;
    }

    @Hook(value=Pointcut.SERVER_PROVIDER_METHOD_BOUND)
    public BaseMethodBinding bindMethod(BaseMethodBinding theMethodBinding) {
        boolean allowed = true;
        String resourceName = theMethodBinding.getResourceName();
        RestOperationTypeEnum restOperationType = theMethodBinding.getRestOperationType();
        switch (restOperationType) {
            case EXTENDED_OPERATION_SERVER: 
            case EXTENDED_OPERATION_TYPE: 
            case EXTENDED_OPERATION_INSTANCE: {
                OperationMethodBinding operationMethodBinding = (OperationMethodBinding)theMethodBinding;
                if (this.myAllowedKeys.isEmpty() || this.myAllowedKeys.contains(operationMethodBinding.getName())) break;
                allowed = false;
                break;
            }
            default: {
                if (restOperationType == RestOperationTypeEnum.VREAD) {
                    restOperationType = RestOperationTypeEnum.READ;
                }
                String key = InteractionBlockingInterceptor.toKey(resourceName, restOperationType);
                if (this.myAllowedKeys.isEmpty() || this.myAllowedKeys.contains(key)) break;
                allowed = false;
                break;
            }
        }
        if (!allowed) {
            ourLog.info("Skipping method binding for {}:{} provided by {}", new Object[]{resourceName, restOperationType, theMethodBinding.getMethod()});
            return null;
        }
        return theMethodBinding;
    }

    private static String toKey(String theResourceType, RestOperationTypeEnum theRestOperationTypeEnum) {
        if (StringUtils.isBlank((CharSequence)theResourceType)) {
            return theRestOperationTypeEnum.getCode();
        }
        return theResourceType + ":" + theRestOperationTypeEnum.getCode();
    }

    static {
        ourLog = LoggerFactory.getLogger(InteractionBlockingInterceptor.class);
        TreeSet<RestOperationTypeEnum> allowedOpTypes = new TreeSet<RestOperationTypeEnum>();
        allowedOpTypes.add(RestOperationTypeEnum.META);
        allowedOpTypes.add(RestOperationTypeEnum.META_ADD);
        allowedOpTypes.add(RestOperationTypeEnum.META_DELETE);
        allowedOpTypes.add(RestOperationTypeEnum.PATCH);
        allowedOpTypes.add(RestOperationTypeEnum.READ);
        allowedOpTypes.add(RestOperationTypeEnum.CREATE);
        allowedOpTypes.add(RestOperationTypeEnum.UPDATE);
        allowedOpTypes.add(RestOperationTypeEnum.DELETE);
        allowedOpTypes.add(RestOperationTypeEnum.BATCH);
        allowedOpTypes.add(RestOperationTypeEnum.TRANSACTION);
        allowedOpTypes.add(RestOperationTypeEnum.VALIDATE);
        allowedOpTypes.add(RestOperationTypeEnum.SEARCH_TYPE);
        allowedOpTypes.add(RestOperationTypeEnum.HISTORY_TYPE);
        allowedOpTypes.add(RestOperationTypeEnum.HISTORY_INSTANCE);
        allowedOpTypes.add(RestOperationTypeEnum.HISTORY_SYSTEM);
        ALLOWED_OP_TYPES = Collections.unmodifiableSet(allowedOpTypes);
    }

    public static class Builder {
        private final Set<String> myAllowedKeys = new HashSet<String>();
        private final FhirContext myCtx;

        public Builder(@Nonnull FhirContext theCtx) {
            Validate.notNull((Object)theCtx, (String)"theCtx must not be null", (Object[])new Object[0]);
            this.myCtx = theCtx;
        }

        public Builder addAllowedSpec(String theSpec) {
            Validate.notBlank((CharSequence)theSpec, (String)"theSpec must not be null or blank", (Object[])new Object[0]);
            if (theSpec.startsWith("$")) {
                this.addAllowedOperation(theSpec);
                return this;
            }
            int colonIdx = theSpec.indexOf(58);
            Validate.isTrue((colonIdx > 0 ? 1 : 0) != 0, (String)"Invalid interaction allowed spec: %s", (Object[])new Object[]{theSpec});
            String resourceName = theSpec.substring(0, colonIdx);
            String interactionName = theSpec.substring(colonIdx + 1);
            RestOperationTypeEnum interaction = RestOperationTypeEnum.forCode((String)interactionName);
            Validate.notNull((Object)interaction, (String)"Unknown interaction %s in spec %s", (Object[])new Object[]{interactionName, theSpec});
            this.addAllowedInteraction(resourceName, interaction);
            return this;
        }

        private void addAllowedInteraction(String theResourceType, RestOperationTypeEnum theInteractionType) {
            Validate.notBlank((CharSequence)theResourceType, (String)"theResourceType must not be null or blank", (Object[])new Object[0]);
            Validate.notNull((Object)theInteractionType, (String)"theInteractionType must not be null", (Object[])new Object[0]);
            Validate.isTrue((boolean)ALLOWED_OP_TYPES.contains(theInteractionType), (String)"Operation type %s can not be used as an allowable rule", (Object[])new Object[]{theInteractionType});
            Validate.isTrue((this.myCtx.getResourceType(theResourceType) != null ? 1 : 0) != 0, (String)"Unknown resource type: %s", (Object[])new Object[0]);
            String key = InteractionBlockingInterceptor.toKey(theResourceType, theInteractionType);
            this.myAllowedKeys.add(key);
        }

        private void addAllowedOperation(String theOperationName) {
            Validate.notBlank((CharSequence)theOperationName, (String)"theOperationName must not be null or blank", (Object[])new Object[0]);
            Validate.isTrue((boolean)theOperationName.startsWith("$"), (String)"Invalid operation name: %s", (Object[])new Object[]{theOperationName});
            this.myAllowedKeys.add(theOperationName);
        }

        public InteractionBlockingInterceptor build() {
            return new InteractionBlockingInterceptor(this);
        }
    }
}

