/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.server.IRestfulResponse;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.ResponseDetails;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.UrlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class ResponseHighlighterInterceptor {
    public static final String PARAM_RAW = "_raw";
    public static final String PARAM_RAW_TRUE = "true";
    private static final Logger ourLog = LoggerFactory.getLogger(ResponseHighlighterInterceptor.class);
    private static final String[] PARAM_FORMAT_VALUE_JSON = new String[]{"json"};
    private static final String[] PARAM_FORMAT_VALUE_XML = new String[]{"xml"};
    private static final String[] PARAM_FORMAT_VALUE_TTL = new String[]{"ttl"};
    private boolean myShowRequestHeaders = false;
    private boolean myShowResponseHeaders = true;

    private String createLinkHref(Map<String, String[]> parameters, String formatValue) {
        StringBuilder rawB = new StringBuilder();
        for (String next : parameters.keySet()) {
            if ("_format".equals(next)) continue;
            for (String nextValue : parameters.get(next)) {
                if (StringUtils.isBlank((CharSequence)nextValue)) continue;
                if (rawB.length() == 0) {
                    rawB.append('?');
                } else {
                    rawB.append('&');
                }
                rawB.append(UrlUtil.escapeUrlParam((String)next));
                rawB.append('=');
                rawB.append(UrlUtil.escapeUrlParam((String)nextValue));
            }
        }
        if (rawB.length() == 0) {
            rawB.append('?');
        } else {
            rawB.append('&');
        }
        rawB.append("_format").append('=').append(formatValue);
        String link = rawB.toString();
        return link;
    }

    private int format(String theResultBody, StringBuilder theTarget, EncodingEnum theEncodingEnum) {
        String str = StringEscapeUtils.escapeHtml4((String)theResultBody);
        if (str == null || theEncodingEnum == null) {
            theTarget.append(str);
            return 0;
        }
        theTarget.append("<div id=\"line1\">");
        boolean inValue = false;
        boolean inQuote = false;
        boolean inTag = false;
        boolean inTurtleDirective = false;
        boolean startingLineNext = true;
        boolean startingLine = false;
        int lineCount = 1;
        for (int i = 0; i < str.length(); ++i) {
            int nextChar6;
            int prevChar = i > 0 ? (int)str.charAt(i - 1) : 32;
            char nextChar = str.charAt(i);
            int nextChar2 = i + 1 < str.length() ? (int)str.charAt(i + 1) : 32;
            int nextChar3 = i + 2 < str.length() ? (int)str.charAt(i + 2) : 32;
            int nextChar4 = i + 3 < str.length() ? (int)str.charAt(i + 3) : 32;
            int nextChar5 = i + 4 < str.length() ? (int)str.charAt(i + 4) : 32;
            int n = nextChar6 = i + 5 < str.length() ? (int)str.charAt(i + 5) : 32;
            if (nextChar == '\n') {
                if (inTurtleDirective) {
                    theTarget.append("</span>");
                    inTurtleDirective = false;
                }
                theTarget.append("</div><div id=\"line");
                theTarget.append(++lineCount);
                theTarget.append("\" onclick=\"updateHighlightedLineTo('#L");
                theTarget.append(lineCount);
                theTarget.append("');\">");
                startingLineNext = true;
                continue;
            }
            if (startingLineNext) {
                startingLineNext = false;
                startingLine = true;
            } else {
                startingLine = false;
            }
            if (theEncodingEnum == EncodingEnum.JSON) {
                if (inQuote) {
                    theTarget.append(nextChar);
                    if (prevChar != 92 && nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                        theTarget.append("quot;</span>");
                        i += 5;
                        inQuote = false;
                        continue;
                    }
                    if (nextChar != '\\' || nextChar2 != 34) continue;
                    theTarget.append("quot;</span>");
                    i += 5;
                    inQuote = false;
                    continue;
                }
                if (nextChar == ':') {
                    inValue = true;
                    theTarget.append(nextChar);
                    continue;
                }
                if (nextChar == '[' || nextChar == '{') {
                    theTarget.append("<span class='hlControl'>");
                    theTarget.append(nextChar);
                    theTarget.append("</span>");
                    inValue = false;
                    continue;
                }
                if (nextChar == '{' || nextChar == '}' || nextChar == ',') {
                    theTarget.append("<span class='hlControl'>");
                    theTarget.append(nextChar);
                    theTarget.append("</span>");
                    inValue = false;
                    continue;
                }
                if (nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                    if (inValue) {
                        theTarget.append("<span class='hlQuot'>&quot;");
                    } else {
                        theTarget.append("<span class='hlTagName'>&quot;");
                    }
                    inQuote = true;
                    i += 5;
                    continue;
                }
                if (nextChar == ':') {
                    theTarget.append("<span class='hlControl'>");
                    theTarget.append(nextChar);
                    theTarget.append("</span>");
                    inValue = true;
                    continue;
                }
                theTarget.append(nextChar);
                continue;
            }
            if (theEncodingEnum == EncodingEnum.RDF) {
                if (inQuote) {
                    theTarget.append(nextChar);
                    if (prevChar != 92 && nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                        theTarget.append("quot;</span>");
                        i += 5;
                        inQuote = false;
                        continue;
                    }
                    if (nextChar != '\\' || nextChar2 != 34) continue;
                    theTarget.append("quot;</span>");
                    i += 5;
                    inQuote = false;
                    continue;
                }
                if (startingLine && nextChar == '@') {
                    inTurtleDirective = true;
                    theTarget.append("<span class='hlTagName'>");
                    theTarget.append(nextChar);
                    continue;
                }
                if (startingLine) {
                    inTurtleDirective = true;
                    theTarget.append("<span class='hlTagName'>");
                    theTarget.append(nextChar);
                    continue;
                }
                if (nextChar == '[' || nextChar == ']' || nextChar == ';' || nextChar == ':') {
                    theTarget.append("<span class='hlControl'>");
                    theTarget.append(nextChar);
                    theTarget.append("</span>");
                    continue;
                }
                if (nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                    theTarget.append("<span class='hlQuot'>&quot;");
                    inQuote = true;
                    i += 5;
                    continue;
                }
                theTarget.append(nextChar);
                continue;
            }
            if (inQuote) {
                theTarget.append(nextChar);
                if (nextChar != '&' || nextChar2 != 113 || nextChar3 != 117 || nextChar4 != 111 || nextChar5 != 116 || nextChar6 != 59) continue;
                theTarget.append("quot;</span>");
                i += 5;
                inQuote = false;
                continue;
            }
            if (inTag) {
                if (nextChar == '&' && nextChar2 == 103 && nextChar3 == 116 && nextChar4 == 59) {
                    theTarget.append("</span><span class='hlControl'>&gt;</span>");
                    inTag = false;
                    i += 3;
                    continue;
                }
                if (nextChar == ' ') {
                    theTarget.append("</span><span class='hlAttr'>");
                    theTarget.append(nextChar);
                    continue;
                }
                if (nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                    theTarget.append("<span class='hlQuot'>&quot;");
                    inQuote = true;
                    i += 5;
                    continue;
                }
                theTarget.append(nextChar);
                continue;
            }
            if (nextChar == '&' && nextChar2 == 108 && nextChar3 == 116 && nextChar4 == 59) {
                theTarget.append("<span class='hlControl'>&lt;</span><span class='hlTagName'>");
                inTag = true;
                i += 3;
                continue;
            }
            theTarget.append(nextChar);
        }
        theTarget.append("</div>");
        return lineCount;
    }

    @Hook(value=Pointcut.SERVER_HANDLE_EXCEPTION, order=10000)
    public boolean handleException(RequestDetails theRequestDetails, BaseServerResponseException theException, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) {
        Set<String> accept = RestfulServerUtils.parseAcceptHeaderAndReturnHighestRankedOptions(theServletRequest);
        if (!accept.contains("text/html")) {
            return true;
        }
        String requestedWith = theServletRequest.getHeader("X-Requested-With");
        if (requestedWith != null) {
            return true;
        }
        if (theRequestDetails.getRequestType() != RequestTypeEnum.GET) {
            return true;
        }
        IBaseOperationOutcome oo = theException.getOperationOutcome();
        if (oo == null) {
            return true;
        }
        ResponseDetails responseDetails = new ResponseDetails();
        responseDetails.setResponseResource((IBaseResource)oo);
        responseDetails.setResponseCode(theException.getStatusCode());
        BaseResourceReturningMethodBinding.callOutgoingFailureOperationOutcomeHook(theRequestDetails, oo);
        this.streamResponse(theRequestDetails, theServletResponse, responseDetails.getResponseResource(), null, (ServletRequest)theServletRequest, responseDetails.getResponseCode());
        return false;
    }

    public boolean isShowRequestHeaders() {
        return this.myShowRequestHeaders;
    }

    public ResponseHighlighterInterceptor setShowRequestHeaders(boolean theShowRequestHeaders) {
        this.myShowRequestHeaders = theShowRequestHeaders;
        return this;
    }

    public boolean isShowResponseHeaders() {
        return this.myShowResponseHeaders;
    }

    public ResponseHighlighterInterceptor setShowResponseHeaders(boolean theShowResponseHeaders) {
        this.myShowResponseHeaders = theShowResponseHeaders;
        return this;
    }

    @Hook(value=Pointcut.SERVER_OUTGOING_GRAPHQL_RESPONSE, order=10000)
    public boolean outgoingGraphqlResponse(RequestDetails theRequestDetails, String theRequest, String theResponse, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws AuthenticationException {
        if (this.handleOutgoingResponse(theRequestDetails, null, theServletRequest, theServletResponse, theResponse, null)) {
            return true;
        }
        theRequestDetails.setAttribute("ResponseHighlighterInterceptorHandled", Boolean.TRUE);
        return true;
    }

    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE, order=10000)
    public boolean outgoingResponse(RequestDetails theRequestDetails, ResponseDetails theResponseObject, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws AuthenticationException {
        IBaseResource resourceResponse;
        String graphqlResponse;
        return !Boolean.TRUE.equals(theRequestDetails.getAttribute("ResponseHighlighterInterceptorHandled")) && this.handleOutgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse, graphqlResponse = null, resourceResponse = theResponseObject.getResponseResource());
    }

    @Hook(value=Pointcut.SERVER_CAPABILITY_STATEMENT_GENERATED)
    public void capabilityStatementGenerated(RequestDetails theRequestDetails, IBaseConformance theCapabilityStatement) {
        FhirTerser terser = theRequestDetails.getFhirContext().newTerser();
        Set<String> formats = terser.getValues((IBase)theCapabilityStatement, "format", IPrimitiveType.class).stream().map(t -> t.getValueAsString()).collect(Collectors.toSet());
        this.addFormatConditionally(theCapabilityStatement, terser, formats, "application/fhir+json", "html/json");
        this.addFormatConditionally(theCapabilityStatement, terser, formats, "application/fhir+xml", "html/xml");
        this.addFormatConditionally(theCapabilityStatement, terser, formats, "application/x-turtle", "html/turtle");
    }

    private void addFormatConditionally(IBaseConformance theCapabilityStatement, FhirTerser terser, Set<String> formats, String wanted, String toAdd) {
        if (formats.contains(wanted)) {
            terser.addElement((IBase)theCapabilityStatement, "format", toAdd);
        }
    }

    private boolean handleOutgoingResponse(RequestDetails theRequestDetails, ResponseDetails theResponseObject, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, String theGraphqlResponse, IBaseResource theResourceResponse) {
        if (theResourceResponse == null && theGraphqlResponse == null) {
            return true;
        }
        String[] rawParamValues = theRequestDetails.getParameters().get(PARAM_RAW);
        if (rawParamValues != null && rawParamValues.length > 0 && rawParamValues[0].equals(PARAM_RAW_TRUE)) {
            ourLog.warn("Client is using non-standard/legacy  _raw parameter - Use _format=json or _format=xml instead, as this parmameter will be removed at some point");
            return true;
        }
        boolean force = false;
        String[] formatParams = theRequestDetails.getParameters().get("_format");
        if (formatParams != null && formatParams.length > 0) {
            String formatParam = StringUtils.defaultString((String)formatParams[0]);
            int semiColonIdx = formatParam.indexOf(59);
            if (semiColonIdx != -1) {
                formatParam = formatParam.substring(0, semiColonIdx);
            }
            if (Constants.FORMATS_HTML.contains(formatParam = StringUtils.trim((String)formatParam))) {
                force = true;
            } else if ("html/xml".equals(formatParam)) {
                force = true;
                theRequestDetails.addParameter("_format", PARAM_FORMAT_VALUE_XML);
            } else if ("html/json".equals(formatParam)) {
                force = true;
                theRequestDetails.addParameter("_format", PARAM_FORMAT_VALUE_JSON);
            } else if ("html/turtle".equals(formatParam)) {
                force = true;
                theRequestDetails.addParameter("_format", PARAM_FORMAT_VALUE_TTL);
            } else {
                return true;
            }
        }
        Set<String> highestRankedAcceptValues = RestfulServerUtils.parseAcceptHeaderAndReturnHighestRankedOptions(theServletRequest);
        if (!force && !highestRankedAcceptValues.contains("text/html")) {
            return true;
        }
        if (!force && StringUtils.isNotBlank((CharSequence)theServletRequest.getHeader("X-Requested-With"))) {
            return true;
        }
        if (!force && StringUtils.isNotBlank((CharSequence)theServletRequest.getHeader("Origin"))) {
            return true;
        }
        if (!force && theRequestDetails.getRequestType() != RequestTypeEnum.GET) {
            return true;
        }
        if (!force && theResponseObject != null && theResponseObject.getResponseResource() instanceof IBaseBinary) {
            return true;
        }
        this.streamResponse(theRequestDetails, theServletResponse, theResourceResponse, theGraphqlResponse, (ServletRequest)theServletRequest, 200);
        return false;
    }

    private void streamRequestHeaders(ServletRequest theServletRequest, StringBuilder b) {
        if (theServletRequest instanceof HttpServletRequest) {
            HttpServletRequest sr = (HttpServletRequest)theServletRequest;
            b.append("<h1>Request</h1>");
            b.append("<div class=\"headersDiv\">");
            Enumeration headerNamesEnum = sr.getHeaderNames();
            while (headerNamesEnum.hasMoreElements()) {
                String nextHeaderName = (String)headerNamesEnum.nextElement();
                Enumeration headerValuesEnum = sr.getHeaders(nextHeaderName);
                while (headerValuesEnum.hasMoreElements()) {
                    String nextHeaderValue = (String)headerValuesEnum.nextElement();
                    this.appendHeader(b, nextHeaderName, nextHeaderValue);
                }
            }
            b.append("</div>");
        }
    }

    private void streamResponse(RequestDetails theRequestDetails, HttpServletResponse theServletResponse, IBaseResource theResource, String theGraphqlResponse, ServletRequest theServletRequest, int theStatusCode) {
        EncodingEnum encoding;
        String encoded;
        Map<String, String[]> parameters = theRequestDetails.getParameters();
        if (StringUtils.isNotBlank((CharSequence)theGraphqlResponse)) {
            encoded = theGraphqlResponse;
            encoding = EncodingEnum.JSON;
        } else {
            IParser p;
            if (parameters.containsKey("_format")) {
                FhirVersionEnum forVersion = theResource.getStructureFhirVersionEnum();
                p = RestfulServerUtils.getNewParser(theRequestDetails.getServer().getFhirContext(), forVersion, theRequestDetails);
            } else {
                EncodingEnum defaultResponseEncoding = theRequestDetails.getServer().getDefaultResponseEncoding();
                p = defaultResponseEncoding.newParser(theRequestDetails.getServer().getFhirContext());
                RestfulServerUtils.configureResponseParser(theRequestDetails, p);
            }
            boolean prettyPrintResponse = true;
            String[] prettyParams = parameters.get("_pretty");
            if (prettyParams != null && prettyParams.length > 0 && "false".equals(prettyParams[0])) {
                prettyPrintResponse = false;
            }
            if (prettyPrintResponse) {
                p.setPrettyPrint(true);
            }
            encoding = p.getEncoding();
            encoded = p.encodeResourceToString(theResource);
        }
        if (theRequestDetails.getServer() instanceof RestfulServer) {
            RestfulServer rs = (RestfulServer)theRequestDetails.getServer();
            rs.addHeadersToResponse(theServletResponse);
        }
        try {
            Date startTime;
            if (theStatusCode > 299) {
                theServletResponse.setStatus(theStatusCode);
            }
            theServletResponse.setContentType("text/html; charset=UTF-8");
            StringBuilder outputBuffer = new StringBuilder();
            outputBuffer.append("<html lang=\"en\">\n");
            outputBuffer.append("\t<head>\n");
            outputBuffer.append("\t\t<meta charset=\"utf-8\" />\n");
            outputBuffer.append("       <style>\n");
            outputBuffer.append(".httpStatusDiv {");
            outputBuffer.append("  font-size: 1.2em;");
            outputBuffer.append("  font-weight: bold;");
            outputBuffer.append("}");
            outputBuffer.append(".hlQuot { color: #88F; }\n");
            outputBuffer.append(".hlQuot a { text-decoration: underline; text-decoration-color: #CCC; }\n");
            outputBuffer.append(".hlQuot a:HOVER { text-decoration: underline; text-decoration-color: #008; }\n");
            outputBuffer.append(".hlQuot .uuid, .hlQuot .dateTime {\n");
            outputBuffer.append("  user-select: all;\n");
            outputBuffer.append("  -moz-user-select: all;\n");
            outputBuffer.append("  -webkit-user-select: all;\n");
            outputBuffer.append("  -ms-user-select: element;\n");
            outputBuffer.append("}\n");
            outputBuffer.append(".hlAttr {\n");
            outputBuffer.append("  color: #888;\n");
            outputBuffer.append("}\n");
            outputBuffer.append(".hlTagName {\n");
            outputBuffer.append("  color: #006699;\n");
            outputBuffer.append("}\n");
            outputBuffer.append(".hlControl {\n");
            outputBuffer.append("  color: #660000;\n");
            outputBuffer.append("}\n");
            outputBuffer.append(".hlText {\n");
            outputBuffer.append("  color: #000000;\n");
            outputBuffer.append("}\n");
            outputBuffer.append(".hlUrlBase {\n");
            outputBuffer.append("}");
            outputBuffer.append(".headersDiv {\n");
            outputBuffer.append("  padding: 10px;");
            outputBuffer.append("  margin-left: 10px;");
            outputBuffer.append("  border: 1px solid #CCC;");
            outputBuffer.append("  border-radius: 10px;");
            outputBuffer.append("}");
            outputBuffer.append(".headersRow {\n");
            outputBuffer.append("}");
            outputBuffer.append(".headerName {\n");
            outputBuffer.append("  color: #888;\n");
            outputBuffer.append("  font-family: monospace;\n");
            outputBuffer.append("}");
            outputBuffer.append(".headerValue {\n");
            outputBuffer.append("  color: #88F;\n");
            outputBuffer.append("  font-family: monospace;\n");
            outputBuffer.append("}");
            outputBuffer.append(".responseBodyTable {");
            outputBuffer.append("  width: 100%;\n");
            outputBuffer.append("  margin-left: 0px;\n");
            outputBuffer.append("  margin-top: -10px;\n");
            outputBuffer.append("  position: relative;\n");
            outputBuffer.append("}");
            outputBuffer.append(".responseBodyTableFirstColumn {");
            outputBuffer.append("}");
            outputBuffer.append(".responseBodyTableSecondColumn {");
            outputBuffer.append("  position: absolute;\n");
            outputBuffer.append("  margin-left: 70px;\n");
            outputBuffer.append("  vertical-align: top;\n");
            outputBuffer.append("  left: 0px;\n");
            outputBuffer.append("  right: 0px;\n");
            outputBuffer.append("}");
            outputBuffer.append(".responseBodyTableSecondColumn PRE {");
            outputBuffer.append("  margin: 0px;");
            outputBuffer.append("}");
            outputBuffer.append(".sizeInfo {");
            outputBuffer.append("  margin-top: 20px;");
            outputBuffer.append("  font-size: 0.8em;");
            outputBuffer.append("}");
            outputBuffer.append(".lineAnchor A {");
            outputBuffer.append("  text-decoration: none;");
            outputBuffer.append("  padding-left: 20px;");
            outputBuffer.append("}");
            outputBuffer.append(".lineAnchor {");
            outputBuffer.append("  display: block;");
            outputBuffer.append("  padding-right: 20px;");
            outputBuffer.append("}");
            outputBuffer.append(".selectedLine {");
            outputBuffer.append("  background-color: #EEF;");
            outputBuffer.append("  font-weight: bold;");
            outputBuffer.append("}");
            outputBuffer.append("H1 {");
            outputBuffer.append("  font-size: 1.1em;");
            outputBuffer.append("  color: #666;");
            outputBuffer.append("}");
            outputBuffer.append("BODY {\n");
            outputBuffer.append("  font-family: Arial;\n");
            outputBuffer.append("}");
            outputBuffer.append("       </style>\n");
            outputBuffer.append("\t</head>\n");
            outputBuffer.append("\n");
            outputBuffer.append("\t<body>");
            outputBuffer.append("<p>");
            if (StringUtils.isBlank((CharSequence)theGraphqlResponse)) {
                outputBuffer.append("This result is being rendered in HTML for easy viewing. ");
                outputBuffer.append("You may access this content as ");
                if (theRequestDetails.getFhirContext().isFormatJsonSupported()) {
                    outputBuffer.append("<a href=\"");
                    outputBuffer.append(this.createLinkHref(parameters, "json"));
                    outputBuffer.append("\">Raw JSON</a> or ");
                }
                if (theRequestDetails.getFhirContext().isFormatXmlSupported()) {
                    outputBuffer.append("<a href=\"");
                    outputBuffer.append(this.createLinkHref(parameters, "xml"));
                    outputBuffer.append("\">Raw XML</a> or ");
                }
                if (theRequestDetails.getFhirContext().isFormatRdfSupported()) {
                    outputBuffer.append("<a href=\"");
                    outputBuffer.append(this.createLinkHref(parameters, "ttl"));
                    outputBuffer.append("\">Raw Turtle</a> or ");
                }
                outputBuffer.append("view this content in ");
                if (theRequestDetails.getFhirContext().isFormatJsonSupported()) {
                    outputBuffer.append("<a href=\"");
                    outputBuffer.append(this.createLinkHref(parameters, "html/json"));
                    outputBuffer.append("\">HTML JSON</a> ");
                }
                if (theRequestDetails.getFhirContext().isFormatXmlSupported()) {
                    outputBuffer.append("or ");
                    outputBuffer.append("<a href=\"");
                    outputBuffer.append(this.createLinkHref(parameters, "html/xml"));
                    outputBuffer.append("\">HTML XML</a> ");
                }
                if (theRequestDetails.getFhirContext().isFormatRdfSupported()) {
                    outputBuffer.append("or ");
                    outputBuffer.append("<a href=\"");
                    outputBuffer.append(this.createLinkHref(parameters, "html/turtle"));
                    outputBuffer.append("\">HTML Turtle</a> ");
                }
                outputBuffer.append(".");
            }
            if ((startTime = (Date)theServletRequest.getAttribute(RestfulServer.REQUEST_START_TIME)) != null) {
                long time = System.currentTimeMillis() - startTime.getTime();
                outputBuffer.append(" Response generated in ");
                outputBuffer.append(time);
                outputBuffer.append("ms.");
            }
            outputBuffer.append("</p>");
            outputBuffer.append("\n");
            String statusName = (String)Constants.HTTP_STATUS_NAMES.get(theServletResponse.getStatus());
            statusName = StringUtils.defaultString((String)statusName);
            outputBuffer.append("<div class=\"httpStatusDiv\">");
            outputBuffer.append("HTTP ");
            outputBuffer.append(theServletResponse.getStatus());
            outputBuffer.append(" ");
            outputBuffer.append(statusName);
            outputBuffer.append("</div>");
            outputBuffer.append("\n");
            outputBuffer.append("\n");
            try {
                if (this.isShowRequestHeaders()) {
                    this.streamRequestHeaders(theServletRequest, outputBuffer);
                }
                if (this.isShowResponseHeaders()) {
                    this.streamResponseHeaders(theRequestDetails, theServletResponse, outputBuffer);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            outputBuffer.append("<h1>Response Body</h1>");
            outputBuffer.append("<div class=\"responseBodyTable\">");
            outputBuffer.append("<div class=\"responseBodyTableSecondColumn\"><pre>");
            StringBuilder target = new StringBuilder();
            int linesCount = this.format(encoded, target, encoding);
            outputBuffer.append((CharSequence)target);
            outputBuffer.append("</pre></div>");
            outputBuffer.append("<div class=\"responseBodyTableFirstColumn\"><pre>");
            for (int i = 1; i <= linesCount; ++i) {
                outputBuffer.append("<div class=\"lineAnchor\" id=\"anchor");
                outputBuffer.append(i);
                outputBuffer.append("\">");
                outputBuffer.append("<a href=\"#L");
                outputBuffer.append(i);
                outputBuffer.append("\" name=\"L");
                outputBuffer.append(i);
                outputBuffer.append("\" id=\"L");
                outputBuffer.append(i);
                outputBuffer.append("\">");
                outputBuffer.append(i);
                outputBuffer.append("</a></div>");
            }
            outputBuffer.append("</div></td>");
            outputBuffer.append("</div>");
            outputBuffer.append("\n");
            InputStream jsStream = ResponseHighlighterInterceptor.class.getResourceAsStream("ResponseHighlighter.js");
            String jsStr = jsStream != null ? IOUtils.toString((InputStream)jsStream, (Charset)StandardCharsets.UTF_8) : "console.log('ResponseHighlighterInterceptor: javascript theResource not found')";
            String baseUrl = theRequestDetails.getServerBaseForRequest();
            baseUrl = UrlUtil.sanitizeBaseUrl((String)baseUrl);
            jsStr = jsStr.replace("FHIR_BASE", baseUrl);
            outputBuffer.append("<script type=\"text/javascript\">");
            outputBuffer.append(jsStr);
            outputBuffer.append("</script>\n");
            StopWatch writeSw = new StopWatch();
            theServletResponse.getWriter().append(outputBuffer);
            theServletResponse.getWriter().flush();
            theServletResponse.getWriter().append("<div class=\"sizeInfo\">");
            theServletResponse.getWriter().append("Wrote ");
            this.writeLength(theServletResponse, encoded.length());
            theServletResponse.getWriter().append(" (");
            this.writeLength(theServletResponse, outputBuffer.length());
            theServletResponse.getWriter().append(" total including HTML)");
            theServletResponse.getWriter().append(" in estimated ");
            theServletResponse.getWriter().append(writeSw.toString());
            theServletResponse.getWriter().append("</div>");
            theServletResponse.getWriter().append("</body>");
            theServletResponse.getWriter().append("</html>");
            theServletResponse.getWriter().close();
        }
        catch (IOException e) {
            throw new InternalErrorException(Msg.code((int)322) + e);
        }
    }

    private void writeLength(HttpServletResponse theServletResponse, int theLength) throws IOException {
        double kb = (double)theLength / 1024.0;
        if (kb <= 1000.0) {
            theServletResponse.getWriter().append(String.format("%.1f", kb)).append(" KB");
        } else {
            double mb = kb / 1000.0;
            theServletResponse.getWriter().append(String.format("%.1f", mb)).append(" MB");
        }
    }

    private void streamResponseHeaders(RequestDetails theRequestDetails, HttpServletResponse theServletResponse, StringBuilder b) {
        if (!theServletResponse.getHeaderNames().isEmpty()) {
            b.append("<h1>Response Headers</h1>");
            b.append("<div class=\"headersDiv\">");
            for (String nextHeaderName : theServletResponse.getHeaderNames()) {
                for (Object nextHeaderValue : theServletResponse.getHeaders(nextHeaderName)) {
                    RestfulServerUtils.ResponseEncoding responseEncoding;
                    if (nextHeaderName.equalsIgnoreCase("Content-Type") && (responseEncoding = RestfulServerUtils.determineResponseEncodingNoDefault(theRequestDetails, theRequestDetails.getServer().getDefaultResponseEncoding())) != null && StringUtils.isNotBlank((CharSequence)responseEncoding.getResourceContentType())) {
                        nextHeaderValue = responseEncoding.getResourceContentType() + ";charset=utf-8";
                    }
                    this.appendHeader(b, nextHeaderName, (String)nextHeaderValue);
                }
            }
            IRestfulResponse response = theRequestDetails.getResponse();
            for (Map.Entry<String, List<String>> next : response.getHeaders().entrySet()) {
                String name = next.getKey();
                for (String nextValue : next.getValue()) {
                    this.appendHeader(b, name, nextValue);
                }
            }
            b.append("</div>");
        }
    }

    private void appendHeader(StringBuilder theBuilder, String theHeaderName, String theHeaderValue) {
        theBuilder.append("<div class=\"headersRow\">");
        theBuilder.append("<span class=\"headerName\">").append(theHeaderName).append(": ").append("</span>");
        theBuilder.append("<span class=\"headerValue\">").append(theHeaderValue).append("</span>");
        theBuilder.append("</div>");
    }
}

