/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.servlet;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.rest.api.PreferHeader;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRestfulResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletRequestDetails
extends RequestDetails {
    private static final Logger ourLog = LoggerFactory.getLogger(ServletRequestDetails.class);
    private RestfulServer myServer;
    private HttpServletRequest myServletRequest;
    private HttpServletResponse myServletResponse;

    public ServletRequestDetails() {
        this((IInterceptorBroadcaster)null);
    }

    public ServletRequestDetails(IInterceptorBroadcaster theInterceptorBroadcaster) {
        super(theInterceptorBroadcaster);
        this.setResponse(new ServletRestfulResponse(this));
    }

    public ServletRequestDetails(ServletRequestDetails theRequestDetails) {
        super(theRequestDetails);
        this.myServer = theRequestDetails.getServer();
        this.myServletRequest = theRequestDetails.getServletRequest();
        this.myServletResponse = theRequestDetails.getServletResponse();
    }

    @Override
    protected byte[] getByteStreamRequestContents() {
        try {
            String contentEncoding;
            InputStream inputStream = this.getInputStream();
            byte[] requestContents = IOUtils.toByteArray((InputStream)inputStream);
            if (this.myServer.isUncompressIncomingContents() && "gzip".equals(contentEncoding = this.myServletRequest.getHeader("Content-Encoding"))) {
                ourLog.debug("Uncompressing (GZip) incoming content");
                if (requestContents.length > 0) {
                    GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(requestContents));
                    requestContents = IOUtils.toByteArray((InputStream)gis);
                }
            }
            return requestContents;
        }
        catch (IOException e) {
            ourLog.error("Could not load request resource", (Throwable)e);
            throw new InvalidRequestException(Msg.code((int)308) + String.format("Could not load request resource: %s", e.getMessage()));
        }
    }

    @Override
    public Charset getCharset() {
        Charset charset = null;
        String charsetString = this.myServletRequest.getCharacterEncoding();
        if (StringUtils.isNotBlank((CharSequence)charsetString)) {
            charset = Charset.forName(charsetString);
        }
        return charset;
    }

    @Override
    public FhirContext getFhirContext() {
        return this.getServer().getFhirContext();
    }

    @Override
    public String getHeader(String name) {
        return this.getServletRequest().getHeader(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        Enumeration headers = this.getServletRequest().getHeaders(name);
        return headers == null ? Collections.emptyList() : Collections.list(this.getServletRequest().getHeaders(name));
    }

    @Override
    public Object getAttribute(String theAttributeName) {
        Validate.notBlank((CharSequence)theAttributeName, (String)"theAttributeName must not be null or blank", (Object[])new Object[0]);
        return this.getServletRequest().getAttribute(theAttributeName);
    }

    @Override
    public void setAttribute(String theAttributeName, Object theAttributeValue) {
        Validate.notBlank((CharSequence)theAttributeName, (String)"theAttributeName must not be null or blank", (Object[])new Object[0]);
        this.getServletRequest().setAttribute(theAttributeName, theAttributeValue);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getServletRequest().getInputStream();
    }

    @Override
    public Reader getReader() throws IOException {
        return this.getServletRequest().getReader();
    }

    @Override
    public RestfulServer getServer() {
        return this.myServer;
    }

    @Override
    public String getServerBaseForRequest() {
        return this.getServer().getServerBaseForRequest(this);
    }

    public HttpServletRequest getServletRequest() {
        return this.myServletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.myServletResponse;
    }

    public void setServer(RestfulServer theServer) {
        this.myServer = theServer;
    }

    public ServletRequestDetails setServletRequest(@Nonnull HttpServletRequest myServletRequest) {
        this.myServletRequest = myServletRequest;
        if ("true".equals(myServletRequest.getHeader("X-Rewrite-History"))) {
            this.setRewriteHistory(true);
        }
        this.setRetryFields(myServletRequest);
        return this;
    }

    private void setRetryFields(HttpServletRequest theRequest) {
        if (theRequest == null) {
            return;
        }
        Enumeration headers = theRequest.getHeaders("X-Retry-On-Version-Conflict");
        if (headers != null) {
            Iterator headerIterator = headers.asIterator();
            while (headerIterator.hasNext()) {
                String headerValue = (String)headerIterator.next();
                if (!StringUtils.isNotBlank((CharSequence)headerValue)) continue;
                StringTokenizer tok = new StringTokenizer(headerValue, ";");
                while (tok.hasMoreTokens()) {
                    String next = StringUtils.trim((String)tok.nextToken());
                    if (next.equals("retry")) {
                        this.setRetry(true);
                        continue;
                    }
                    if (!next.startsWith("max-retries=")) continue;
                    String val = StringUtils.trim((String)next.substring("max-retries=".length()));
                    int maxRetries = Integer.parseInt(val);
                    this.setMaxRetries(maxRetries);
                }
            }
        }
    }

    public void setServletResponse(HttpServletResponse myServletResponse) {
        this.myServletResponse = myServletResponse;
    }

    public Map<String, List<String>> getHeaders() {
        HashMap retVal = new HashMap();
        Enumeration names = this.myServletRequest.getHeaderNames();
        while (names.hasMoreElements()) {
            String nextName = (String)names.nextElement();
            ArrayList<String> headerValues = new ArrayList<String>();
            retVal.put(nextName, headerValues);
            Enumeration valuesEnum = this.myServletRequest.getHeaders(nextName);
            while (valuesEnum.hasMoreElements()) {
                headerValues.add((String)valuesEnum.nextElement());
            }
        }
        return Collections.unmodifiableMap(retVal);
    }

    public boolean isPreferRespondAsync() {
        String preferHeader = this.getHeader("Prefer");
        PreferHeader prefer = RestfulServerUtils.parsePreferHeader(null, preferHeader);
        return prefer.getRespondAsync();
    }
}

