/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.BaseResponseTerminologyInterceptor;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.IModelVisitor;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class ResponseTerminologyDisplayPopulationInterceptor
extends BaseResponseTerminologyInterceptor {
    private final BaseRuntimeChildDefinition myCodingSystemChild;
    private final BaseRuntimeChildDefinition myCodingCodeChild;
    private final Class<? extends IBase> myCodingType;
    private final BaseRuntimeElementCompositeDefinition<?> myCodingDefinitition;
    private final BaseRuntimeChildDefinition myCodingDisplayChild;
    private final RuntimePrimitiveDatatypeDefinition myStringDefinition;

    public ResponseTerminologyDisplayPopulationInterceptor(IValidationSupport theValidationSupport) {
        super(theValidationSupport);
        this.myCodingDefinitition = (BaseRuntimeElementCompositeDefinition)Objects.requireNonNull(this.myContext.getElementDefinition("Coding"));
        this.myCodingType = this.myCodingDefinitition.getImplementingClass();
        this.myCodingSystemChild = this.myCodingDefinitition.getChildByName("system");
        this.myCodingCodeChild = this.myCodingDefinitition.getChildByName("code");
        this.myCodingDisplayChild = this.myCodingDefinitition.getChildByName("display");
        this.myStringDefinition = (RuntimePrimitiveDatatypeDefinition)this.myContext.getElementDefinition("string");
    }

    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE, order=110)
    public void handleResource(RequestDetails theRequestDetails, IBaseResource theResource) {
        List<IBaseResource> resources = this.toListForProcessing(theRequestDetails, theResource);
        FhirTerser terser = this.myContext.newTerser();
        for (IBaseResource nextResource : resources) {
            terser.visit(nextResource, (IModelVisitor)new MappingVisitor());
        }
    }

    private class MappingVisitor
    implements IModelVisitor {
        private MappingVisitor() {
        }

        public void acceptElement(IBaseResource theResource, IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition) {
            if (ResponseTerminologyDisplayPopulationInterceptor.this.myCodingType.isAssignableFrom(theElement.getClass())) {
                IValidationSupport.LookupCodeResult lookupCodeResult;
                String system = ResponseTerminologyDisplayPopulationInterceptor.this.myCodingSystemChild.getAccessor().getFirstValueOrNull(theElement).map(t -> (IPrimitiveType)t).map(t -> t.getValueAsString()).orElse(null);
                String code = ResponseTerminologyDisplayPopulationInterceptor.this.myCodingCodeChild.getAccessor().getFirstValueOrNull(theElement).map(t -> (IPrimitiveType)t).map(t -> t.getValueAsString()).orElse(null);
                if (StringUtils.isBlank((CharSequence)system) || StringUtils.isBlank((CharSequence)code)) {
                    return;
                }
                String display = ResponseTerminologyDisplayPopulationInterceptor.this.myCodingDisplayChild.getAccessor().getFirstValueOrNull(theElement).map(t -> (IPrimitiveType)t).map(t -> t.getValueAsString()).orElse(null);
                if (StringUtils.isNotBlank((CharSequence)display)) {
                    return;
                }
                ValidationSupportContext validationSupportContext = new ValidationSupportContext(ResponseTerminologyDisplayPopulationInterceptor.this.myValidationSupport);
                if (ResponseTerminologyDisplayPopulationInterceptor.this.myValidationSupport.isCodeSystemSupported(validationSupportContext, system) && (lookupCodeResult = ResponseTerminologyDisplayPopulationInterceptor.this.myValidationSupport.lookupCode(validationSupportContext, system, code)) != null && lookupCodeResult.isFound()) {
                    String newDisplay = lookupCodeResult.getCodeDisplay();
                    IPrimitiveType newString = (IPrimitiveType)ResponseTerminologyDisplayPopulationInterceptor.this.myStringDefinition.newInstance((Object)newDisplay);
                    ResponseTerminologyDisplayPopulationInterceptor.this.myCodingDisplayChild.getMutator().addValue(theElement, (IBase)newString);
                }
            }
        }
    }
}

