/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.QualifierDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.SearchParameter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class RawParamsParameter
implements IParameter {
    private final List<IParameter> myAllMethodParameters;

    public RawParamsParameter(List<IParameter> theParameters) {
        this.myAllMethodParameters = theParameters;
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, BaseMethodBinding theMethodBinding) throws InternalErrorException, InvalidRequestException {
        HashMap<String, List<String>> retVal = null;
        for (String nextName : theRequest.getParameters().keySet()) {
            if (nextName.startsWith("_")) continue;
            QualifierDetails qualifiers = QualifierDetails.extractQualifiersFromParameterName((String)nextName);
            boolean alreadyCaptured = false;
            for (IParameter nextParameter : this.myAllMethodParameters) {
                SearchParameter nextSearchParam;
                if (!(nextParameter instanceof SearchParameter) || !(nextSearchParam = (SearchParameter)nextParameter).getName().equals(qualifiers.getParamName()) || !qualifiers.passes(nextSearchParam.getQualifierWhitelist(), nextSearchParam.getQualifierBlacklist())) continue;
                alreadyCaptured = true;
                break;
            }
            if (alreadyCaptured) continue;
            if (retVal == null) {
                retVal = new HashMap<String, List<String>>();
            }
            retVal.put(nextName, Arrays.asList(theRequest.getParameters().get(nextName)));
        }
        return retVal;
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        Validate.isTrue((boolean)theParameterType.equals(Map.class), (String)("Parameter with @" + RawParam.class + " must be of type Map<String, List<String>>"), (Object[])new Object[0]);
    }
}

