/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server;

import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.BaseRestfulResponse;
import ca.uhn.fhir.util.IoUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang3.Validate;

public class SystemRestfulResponse
extends BaseRestfulResponse<SystemRequestDetails> {
    private Writer myWriter;
    private ByteArrayOutputStream myOutputStream;

    public SystemRestfulResponse(SystemRequestDetails theSystemRequestDetails) {
        super(theSystemRequestDetails);
    }

    @Override
    @Nonnull
    public Writer getResponseWriter(int theStatusCode, String theContentType, String theCharset, boolean theRespondGzip) throws IOException {
        Validate.isTrue((this.myWriter == null ? 1 : 0) != 0, (String)"getResponseWriter() called multiple times", (Object[])new Object[0]);
        Validate.isTrue((this.myOutputStream == null ? 1 : 0) != 0, (String)"getResponseWriter() called after getResponseOutputStream()", (Object[])new Object[0]);
        this.myWriter = new StringWriter();
        return this.myWriter;
    }

    @Override
    @Nonnull
    public OutputStream getResponseOutputStream(int theStatusCode, String theContentType, @Nullable Integer theContentLength) throws IOException {
        Validate.isTrue((this.myWriter == null ? 1 : 0) != 0, (String)"getResponseOutputStream() called multiple times", (Object[])new Object[0]);
        Validate.isTrue((this.myOutputStream == null ? 1 : 0) != 0, (String)"getResponseOutputStream() called after getResponseWriter()", (Object[])new Object[0]);
        this.myOutputStream = new ByteArrayOutputStream();
        return this.myOutputStream;
    }

    @Override
    public Object commitResponse(@Nonnull Closeable theWriterOrOutputStream) throws IOException {
        IoUtil.closeQuietly((AutoCloseable)theWriterOrOutputStream);
        return ((SystemRequestDetails)this.getRequestDetails()).getServer().getFhirContext().newJsonParser().parseResource(this.myWriter.toString());
    }
}

