/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server.bulk;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.model.api.BaseBatchJobParameters;
import ca.uhn.fhir.rest.server.util.JsonDateDeserializer;
import ca.uhn.fhir.rest.server.util.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class BulkExportJobParameters
extends BaseBatchJobParameters {
    @JsonProperty(value="resourceTypes")
    private List<String> myResourceTypes;
    @JsonSerialize(using=JsonDateSerializer.class)
    @JsonDeserialize(using=JsonDateDeserializer.class)
    @JsonProperty(value="since")
    private Date mySince;
    @JsonProperty(value="exportId")
    private String myExportId;
    @JsonProperty(value="filters")
    private List<String> myFilters;
    @JsonProperty(value="postFetchFilterUrls")
    private List<String> myPostFetchFilterUrls;
    @JsonProperty(value="outputFormat")
    private String myOutputFormat;
    @JsonProperty(value="exportStyle")
    private ExportStyle myExportStyle;
    @JsonProperty(value="patientIds")
    private List<String> myPatientIds = new ArrayList<String>();
    @JsonProperty(value="originalRequestUrl")
    private String myOriginalRequestUrl;
    @JsonProperty(value="groupId")
    private String myGroupId;
    @JsonProperty(value="expandMdm")
    private boolean myExpandMdm;
    @JsonProperty(value="partitionId")
    private RequestPartitionId myPartitionId;
    @JsonProperty(value="binarySecurityContextIdentifierSystem")
    private String myBinarySecurityContextIdentifierSystem;
    @JsonProperty(value="binarySecurityContextIdentifierValue")
    private String myBinarySecurityContextIdentifierValue;

    public String getExportIdentifier() {
        return this.myExportId;
    }

    public void setExportIdentifier(String theExportId) {
        this.myExportId = theExportId;
    }

    public List<String> getResourceTypes() {
        if (this.myResourceTypes == null) {
            this.myResourceTypes = new ArrayList<String>();
        }
        return this.myResourceTypes;
    }

    public void setResourceTypes(Collection<String> theResourceTypes) {
        this.getResourceTypes().clear();
        if (theResourceTypes != null) {
            this.getResourceTypes().addAll(theResourceTypes);
        }
    }

    public Date getSince() {
        return this.mySince;
    }

    public void setSince(Date theSince) {
        this.mySince = theSince;
    }

    public List<String> getFilters() {
        if (this.myFilters == null) {
            this.myFilters = new ArrayList<String>();
        }
        return this.myFilters;
    }

    public void setFilters(Collection<String> theFilters) {
        this.getFilters().clear();
        if (theFilters != null) {
            this.getFilters().addAll(theFilters);
        }
    }

    public List<String> getPostFetchFilterUrls() {
        if (this.myPostFetchFilterUrls == null) {
            this.myPostFetchFilterUrls = new ArrayList<String>();
        }
        return this.myPostFetchFilterUrls;
    }

    public void setPostFetchFilterUrls(Collection<String> thePostFetchFilterUrls) {
        this.getPostFetchFilterUrls().clear();
        if (thePostFetchFilterUrls != null) {
            this.getPostFetchFilterUrls().addAll(thePostFetchFilterUrls);
        }
    }

    public String getOutputFormat() {
        return this.myOutputFormat;
    }

    public void setOutputFormat(String theOutputFormat) {
        this.myOutputFormat = theOutputFormat;
    }

    public ExportStyle getExportStyle() {
        return this.myExportStyle;
    }

    public void setExportStyle(ExportStyle theExportStyle) {
        this.myExportStyle = theExportStyle;
    }

    public List<String> getPatientIds() {
        if (this.myPatientIds == null) {
            this.myPatientIds = new ArrayList<String>();
        }
        return this.myPatientIds;
    }

    public void setPatientIds(Collection<String> thePatientIds) {
        this.getPatientIds().clear();
        if (thePatientIds != null) {
            this.getPatientIds().addAll(thePatientIds);
        }
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public void setGroupId(String theGroupId) {
        this.myGroupId = theGroupId;
    }

    public boolean isExpandMdm() {
        return this.myExpandMdm;
    }

    public void setExpandMdm(boolean theExpandMdm) {
        this.myExpandMdm = theExpandMdm;
    }

    public String getOriginalRequestUrl() {
        return this.myOriginalRequestUrl;
    }

    public void setOriginalRequestUrl(String theOriginalRequestUrl) {
        this.myOriginalRequestUrl = theOriginalRequestUrl;
    }

    public RequestPartitionId getPartitionId() {
        return this.myPartitionId;
    }

    public void setPartitionId(RequestPartitionId thePartitionId) {
        this.myPartitionId = thePartitionId;
    }

    public void setBinarySecurityContextIdentifierSystem(String theBinarySecurityContextIdentifierSystem) {
        this.myBinarySecurityContextIdentifierSystem = theBinarySecurityContextIdentifierSystem;
    }

    public String getBinarySecurityContextIdentifierSystem() {
        return this.myBinarySecurityContextIdentifierSystem;
    }

    public void setBinarySecurityContextIdentifierValue(String theBinarySecurityContextIdentifierValue) {
        this.myBinarySecurityContextIdentifierValue = theBinarySecurityContextIdentifierValue;
    }

    public String getBinarySecurityContextIdentifierValue() {
        return this.myBinarySecurityContextIdentifierValue;
    }

    public static enum ExportStyle {
        PATIENT,
        GROUP,
        SYSTEM;

    }
}

