/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.Validate;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsProcessor;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.cors.DefaultCorsProcessor;

public class CorsInterceptor
extends InterceptorAdapter {
    private CorsProcessor myCorsProcessor;
    private CorsConfiguration myConfig;

    public CorsInterceptor() {
        this(CorsInterceptor.createDefaultCorsConfig());
    }

    public CorsInterceptor(CorsConfiguration theConfiguration) {
        Validate.notNull((Object)theConfiguration, (String)"theConfiguration must not be null", (Object[])new Object[0]);
        this.myCorsProcessor = new DefaultCorsProcessor();
        this.setConfig(theConfiguration);
    }

    public CorsConfiguration getConfig() {
        return this.myConfig;
    }

    public void setConfig(CorsConfiguration theConfiguration) {
        this.myConfig = theConfiguration;
    }

    @Override
    public boolean incomingRequestPreProcessed(HttpServletRequest theRequest, HttpServletResponse theResponse) {
        if (CorsUtils.isCorsRequest((HttpServletRequest)theRequest)) {
            boolean isValid;
            try {
                isValid = this.myCorsProcessor.processRequest(this.myConfig, theRequest, theResponse);
            }
            catch (IOException e) {
                throw new InternalErrorException(Msg.code((int)326) + e);
            }
            if (!isValid || CorsUtils.isPreFlightRequest((HttpServletRequest)theRequest)) {
                return false;
            }
        }
        return super.incomingRequestPreProcessed(theRequest, theResponse);
    }

    private static CorsConfiguration createDefaultCorsConfig() {
        CorsConfiguration retVal = new CorsConfiguration();
        retVal.setAllowedHeaders(new ArrayList(Constants.CORS_ALLOWED_HEADERS));
        retVal.setAllowedMethods(new ArrayList(Constants.CORS_ALLWED_METHODS));
        retVal.addExposedHeader("Content-Location");
        retVal.addExposedHeader("Location");
        retVal.addAllowedOrigin("*");
        return retVal;
    }
}

