/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.TranslateConceptResult;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.IModelVisitor;
import com.google.common.collect.ArrayListMultimap;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class ResponseTerminologyTranslationSvc {
    private BaseRuntimeChildDefinition myCodingSystemChild;
    private BaseRuntimeChildDefinition myCodingCodeChild;
    private BaseRuntimeElementDefinition<IPrimitiveType<?>> myUriDefinition;
    private BaseRuntimeElementDefinition<IPrimitiveType<?>> myCodeDefinition;
    private Class<? extends IBase> myCodeableConceptType;
    private Class<? extends IBase> myCodingType;
    private BaseRuntimeChildDefinition myCodeableConceptCodingChild;
    private BaseRuntimeElementCompositeDefinition<?> myCodingDefinition;
    private RuntimePrimitiveDatatypeDefinition myStringDefinition;
    private BaseRuntimeChildDefinition myCodingDisplayChild;
    private Map<String, String> myMappingSpec;
    private final IValidationSupport myValidationSupport;
    private final FhirContext myFhirContext;

    public ResponseTerminologyTranslationSvc(@Nonnull IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
        Validate.notNull((Object)theValidationSupport, (String)"The validation support must not be null", (Object[])new Object[0]);
        this.myFhirContext = theValidationSupport.getFhirContext();
        Validate.notNull((Object)this.myFhirContext, (String)"The validation support must not return a null context", (Object[])new Object[0]);
        BaseRuntimeElementCompositeDefinition codeableConceptDef = (BaseRuntimeElementCompositeDefinition)Objects.requireNonNull(this.myFhirContext.getElementDefinition("CodeableConcept"));
        this.myCodeableConceptType = codeableConceptDef.getImplementingClass();
        this.myCodeableConceptCodingChild = codeableConceptDef.getChildByName("coding");
        this.myCodingDefinition = (BaseRuntimeElementCompositeDefinition)Objects.requireNonNull(this.myFhirContext.getElementDefinition("Coding"));
        this.myCodingType = this.myCodingDefinition.getImplementingClass();
        this.myCodingSystemChild = this.myCodingDefinition.getChildByName("system");
        this.myCodingCodeChild = this.myCodingDefinition.getChildByName("code");
        this.myCodingDisplayChild = this.myCodingDefinition.getChildByName("display");
        this.myUriDefinition = (RuntimePrimitiveDatatypeDefinition)this.myFhirContext.getElementDefinition("uri");
        this.myCodeDefinition = (RuntimePrimitiveDatatypeDefinition)this.myFhirContext.getElementDefinition("code");
        this.myStringDefinition = (RuntimePrimitiveDatatypeDefinition)this.myFhirContext.getElementDefinition("string");
    }

    public void processResourcesForTerminologyTranslation(List<IBaseResource> resources) {
        FhirTerser terser = this.myFhirContext.newTerser();
        for (IBaseResource nextResource : resources) {
            terser.visit(nextResource, (IModelVisitor)new MappingVisitor());
        }
    }

    public void addMappingSpecification(String theSourceCodeSystemUrl, String theTargetCodeSystemUrl) {
        Validate.notBlank((CharSequence)theSourceCodeSystemUrl, (String)"theSourceCodeSystemUrl must not be null or blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)theTargetCodeSystemUrl, (String)"theTargetCodeSystemUrl must not be null or blank", (Object[])new Object[0]);
        this.getMappingSpecifications().put(theSourceCodeSystemUrl, theTargetCodeSystemUrl);
    }

    public void clearMappingSpecifications() {
        this.myMappingSpec.clear();
    }

    public Map<String, String> getMappingSpecifications() {
        if (this.myMappingSpec == null) {
            this.myMappingSpec = new HashMap<String, String>();
        }
        return this.myMappingSpec;
    }

    private class MappingVisitor
    implements IModelVisitor {
        private MappingVisitor() {
        }

        public void acceptElement(IBaseResource theResource, IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition) {
            if (ResponseTerminologyTranslationSvc.this.myCodeableConceptType.isAssignableFrom(theElement.getClass())) {
                ArrayListMultimap foundSystemsToCodes = ArrayListMultimap.create();
                List nextCodeableConceptCodings = ResponseTerminologyTranslationSvc.this.myCodeableConceptCodingChild.getAccessor().getValues(theElement);
                for (IBase nextCodeableConceptCoding : nextCodeableConceptCodings) {
                    String system = ResponseTerminologyTranslationSvc.this.myCodingSystemChild.getAccessor().getFirstValueOrNull(nextCodeableConceptCoding).map(t -> (IPrimitiveType)t).map(IPrimitiveType::getValueAsString).orElse(null);
                    String code = ResponseTerminologyTranslationSvc.this.myCodingCodeChild.getAccessor().getFirstValueOrNull(nextCodeableConceptCoding).map(t -> (IPrimitiveType)t).map(IPrimitiveType::getValueAsString).orElse(null);
                    if (!StringUtils.isNotBlank((CharSequence)system) || !StringUtils.isNotBlank((CharSequence)code) || foundSystemsToCodes.containsKey((Object)system)) continue;
                    foundSystemsToCodes.put((Object)system, (Object)code);
                }
                for (String nextSourceSystem : foundSystemsToCodes.keySet()) {
                    String wantTargetSystem = ResponseTerminologyTranslationSvc.this.getMappingSpecifications().get(nextSourceSystem);
                    if (wantTargetSystem == null || foundSystemsToCodes.containsKey((Object)wantTargetSystem)) continue;
                    for (String code : foundSystemsToCodes.get((Object)nextSourceSystem)) {
                        ArrayList<IBaseCoding> codings = new ArrayList<IBaseCoding>();
                        codings.add(this.createCodingFromPrimitives(nextSourceSystem, code, null));
                        TranslateConceptResults translateConceptResults = ResponseTerminologyTranslationSvc.this.myValidationSupport.translateConcept(new IValidationSupport.TranslateCodeRequest(codings, wantTargetSystem));
                        if (translateConceptResults == null) continue;
                        List mappings = translateConceptResults.getResults();
                        for (TranslateConceptResult nextMapping : mappings) {
                            IBaseCoding newCoding = this.createCodingFromPrimitives(nextMapping.getSystem(), nextMapping.getCode(), nextMapping.getDisplay());
                            ResponseTerminologyTranslationSvc.this.myCodeableConceptCodingChild.getMutator().addValue(theElement, (IBase)newCoding);
                        }
                    }
                }
            }
        }

        private IBaseCoding createCodingFromPrimitives(String system, String code, String display) {
            assert (ResponseTerminologyTranslationSvc.this.myUriDefinition != null);
            assert (ResponseTerminologyTranslationSvc.this.myCodeDefinition != null);
            IBaseCoding newCoding = (IBaseCoding)ResponseTerminologyTranslationSvc.this.myCodingDefinition.newInstance();
            IPrimitiveType newSystem = (IPrimitiveType)ResponseTerminologyTranslationSvc.this.myUriDefinition.newInstance((Object)system);
            ResponseTerminologyTranslationSvc.this.myCodingSystemChild.getMutator().addValue((IBase)newCoding, (IBase)newSystem);
            IPrimitiveType newCode = (IPrimitiveType)ResponseTerminologyTranslationSvc.this.myCodeDefinition.newInstance((Object)code);
            ResponseTerminologyTranslationSvc.this.myCodingCodeChild.getMutator().addValue((IBase)newCoding, (IBase)newCode);
            if (StringUtils.isNotBlank((CharSequence)display)) {
                assert (ResponseTerminologyTranslationSvc.this.myStringDefinition != null);
                IPrimitiveType newDisplay = (IPrimitiveType)ResponseTerminologyTranslationSvc.this.myStringDefinition.newInstance((Object)display);
                ResponseTerminologyTranslationSvc.this.myCodingDisplayChild.getMutator().addValue((IBase)newCoding, (IBase)newDisplay);
            }
            return newCoding;
        }
    }
}

