/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.HapiLocalizer;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.PreferHandlingEnum;
import ca.uhn.fhir.rest.api.PreferHeader;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.SearchMethodBinding;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@Interceptor
public class SearchPreferHandlingInterceptor {
    @Nonnull
    private PreferHandlingEnum myDefaultBehaviour;
    @Nullable
    private ISearchParamRegistry mySearchParamRegistry;

    public SearchPreferHandlingInterceptor() {
        this.setDefaultBehaviour(PreferHandlingEnum.STRICT);
    }

    public SearchPreferHandlingInterceptor(ISearchParamRegistry theSearchParamRegistry) {
        this();
        this.mySearchParamRegistry = theSearchParamRegistry;
    }

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLER_SELECTED)
    public void incomingRequestPostProcessed(RequestDetails theRequestDetails, HttpServletRequest theRequest, HttpServletResponse theResponse) throws AuthenticationException {
        if (!SearchMethodBinding.isPlainSearchRequest(theRequestDetails)) {
            return;
        }
        String resourceName = theRequestDetails.getResourceName();
        if (!theRequestDetails.getFhirContext().getResourceTypes().contains(resourceName)) {
            return;
        }
        String preferHeader = theRequestDetails.getHeader("Prefer");
        PreferHandlingEnum handling = null;
        if (StringUtils.isNotBlank((CharSequence)preferHeader)) {
            PreferHeader parsedPreferHeader = RestfulServerUtils.parsePreferHeader((IRestfulServer)theRequestDetails.getServer(), preferHeader);
            handling = parsedPreferHeader.getHanding();
        }
        if (handling == null) {
            handling = this.getDefaultBehaviour();
        }
        this.removeUnwantedParams(handling, theRequestDetails);
    }

    private void removeUnwantedParams(PreferHandlingEnum theHandling, RequestDetails theRequestDetails) {
        ISearchParamRegistry searchParamRetriever = this.mySearchParamRegistry;
        if (searchParamRetriever == null) {
            searchParamRetriever = ((RestfulServer)theRequestDetails.getServer()).createConfiguration();
        }
        String resourceName = theRequestDetails.getResourceName();
        HashMap<String, String[]> newMap = null;
        for (String paramName : theRequestDetails.getParameters().keySet()) {
            RuntimeSearchParam activeSearchParam;
            if (paramName.startsWith("_")) continue;
            for (int i = 0; i < paramName.length(); ++i) {
                char nextChar = paramName.charAt(i);
                if (nextChar != '.' && nextChar != ':') continue;
                paramName = paramName.substring(0, i);
                break;
            }
            if ((activeSearchParam = searchParamRetriever.getActiveSearchParam(resourceName, paramName)) != null) continue;
            if (theHandling == PreferHandlingEnum.LENIENT) {
                if (newMap == null) {
                    newMap = new HashMap<String, String[]>(theRequestDetails.getParameters());
                }
                newMap.remove(paramName);
                continue;
            }
            List allowedParams = searchParamRetriever.getActiveSearchParams(resourceName).getSearchParamNames().stream().sorted().distinct().collect(Collectors.toList());
            HapiLocalizer localizer = theRequestDetails.getFhirContext().getLocalizer();
            String msg = localizer.getMessage("ca.uhn.fhir.jpa.dao.BaseStorageDao.invalidSearchParameter", new Object[]{paramName, resourceName, allowedParams});
            throw new InvalidRequestException(Msg.code((int)323) + msg);
        }
        if (newMap != null) {
            theRequestDetails.setParameters(newMap);
        }
    }

    public PreferHandlingEnum getDefaultBehaviour() {
        return this.myDefaultBehaviour;
    }

    public void setDefaultBehaviour(@Nonnull PreferHandlingEnum theDefaultBehaviour) {
        Validate.notNull((Object)theDefaultBehaviour, (String)"theDefaultBehaviour must not be null", (Object[])new Object[0]);
        this.myDefaultBehaviour = theDefaultBehaviour;
    }
}

