/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.consent;

import ca.uhn.fhir.rest.server.interceptor.consent.ConsentOperationStatusEnum;
import java.util.stream.Stream;

public interface IConsentVote {
    public ConsentOperationStatusEnum getStatus();

    public static <T extends IConsentVote> T parallelReduce(T theSeed, Stream<T> theVoteStream) {
        return (T)((IConsentVote)theVoteStream.reduce(theSeed, IConsentVote::parallelReduce));
    }

    public static <T extends IConsentVote> T parallelReduce(T theAccumulator, T theNextVoter) {
        if (theNextVoter.getStatus().getPrecedence() < theAccumulator.getStatus().getPrecedence()) {
            return theAccumulator;
        }
        return theNextVoter;
    }

    public static <T extends IConsentVote> T serialReduce(T theSeed, Stream<T> theVoterStream) {
        return (T)theVoterStream.filter(IConsentVote::isActiveVote).findFirst().orElse(theSeed);
    }

    public static <T extends IConsentVote> T serialReduce(T theAccumulator, T theNextVoter) {
        if (theAccumulator.getStatus().isAbstain()) {
            return theNextVoter;
        }
        return theAccumulator;
    }

    private static <T extends IConsentVote> boolean isActiveVote(T nextVoter) {
        return nextVoter.getStatus().isActiveVote();
    }
}

