/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.validation.address.impl;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.server.interceptor.validation.address.AddressValidationResult;
import ca.uhn.fhir.rest.server.interceptor.validation.address.impl.BaseRestfulValidator;
import ca.uhn.fhir.rest.server.interceptor.validation.helpers.AddressHelper;
import ca.uhn.fhir.util.ExtensionUtil;
import ca.uhn.fhir.util.TerserUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.entity.ContentType;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class LoquateAddressValidator
extends BaseRestfulValidator {
    private static final Logger ourLog = LoggerFactory.getLogger(LoquateAddressValidator.class);
    public static final String PROPERTY_GEOCODE = "service.geocode";
    public static final String LOQUATE_AQI = "AQI";
    public static final String LOQUATE_AVC = "AVC";
    public static final String LOQUATE_GEO_ACCURACY = "GeoAccuracy";
    protected static final String[] DUPLICATE_FIELDS_IN_ADDRESS_LINES = new String[]{"Locality", "AdministrativeArea", "PostalCode"};
    protected static final String DEFAULT_DATA_CLEANSE_ENDPOINT = "https://api.addressy.com/Cleansing/International/Batch/v1.00/json4.ws";
    protected static final int MAX_ADDRESS_LINES = 8;
    private Pattern myCommaPattern = Pattern.compile("\\,(\\S)");

    public LoquateAddressValidator(Properties theProperties) {
        super(theProperties);
        Validate.isTrue((theProperties.containsKey("service.key") || theProperties.containsKey("service.endpoint") ? 1 : 0) != 0, (String)("Expected service key or custom service endpoint in the configuration, but got " + theProperties), (Object[])new Object[0]);
    }

    @Override
    protected AddressValidationResult getValidationResult(AddressValidationResult theResult, JsonNode response, FhirContext theFhirContext) {
        Validate.isTrue((response.isArray() && response.size() >= 1 ? 1 : 0) != 0, (String)"Invalid response - expected to get an array of validated addresses", (Object[])new Object[0]);
        JsonNode firstMatch = response.get(0);
        Validate.isTrue((boolean)firstMatch.has("Matches"), (String)"Invalid response - matches are unavailable", (Object[])new Object[0]);
        JsonNode matches = firstMatch.get("Matches");
        Validate.isTrue((boolean)matches.isArray(), (String)"Invalid response - expected to get a validated match in the response", (Object[])new Object[0]);
        JsonNode match = matches.get(0);
        return this.toAddressValidationResult(theResult, match, theFhirContext);
    }

    private AddressValidationResult toAddressValidationResult(AddressValidationResult theResult, JsonNode theMatch, FhirContext theFhirContext) {
        theResult.setValid(this.isValid(theMatch));
        ourLog.debug("Address validation flag {}", (Object)theResult.isValid());
        JsonNode addressNode = theMatch.get("Address");
        if (addressNode != null) {
            theResult.setValidatedAddressString(addressNode.asText());
        }
        ourLog.debug("Validated address string {}", (Object)theResult.getValidatedAddressString());
        theResult.setValidatedAddress(this.toAddress(theMatch, theFhirContext));
        return theResult;
    }

    protected boolean isValid(JsonNode theMatch) {
        String addressQualityIndex = this.getField(theMatch, LOQUATE_AQI);
        return "A".equals(addressQualityIndex) || "B".equals(addressQualityIndex) || "C".equals(addressQualityIndex);
    }

    private String getField(JsonNode theMatch, String theFieldName) {
        String field = null;
        if (theMatch.has(theFieldName)) {
            field = theMatch.get(theFieldName).asText();
        }
        ourLog.debug("Found {}={}", (Object)theFieldName, (Object)field);
        return field;
    }

    protected IBase toAddress(JsonNode match, FhirContext theFhirContext) {
        IBase addressBase = theFhirContext.getElementDefinition("Address").newInstance();
        AddressHelper helper = new AddressHelper(theFhirContext, addressBase);
        helper.setText(this.standardize(this.getString(match, "Address")));
        String str = this.getString(match, "Address1");
        if (str != null) {
            helper.addLine(str);
        }
        if (this.isGeocodeEnabled()) {
            this.toGeolocation(match, helper, theFhirContext);
        }
        this.removeDuplicateAddressLines(match, helper);
        helper.setCity(this.getString(match, "Locality"));
        helper.setState(this.getString(match, "AdministrativeArea"));
        helper.setPostalCode(this.getString(match, "PostalCode"));
        helper.setCountry(this.getString(match, "CountryName"));
        this.addExtension(match, LOQUATE_AQI, "http://hapifhir.org/StructureDefinition/ext-validation-address-quality", helper, theFhirContext);
        this.addExtension(match, LOQUATE_AVC, "http://hapifhir.org/StructureDefinition/ext-validation-address-verification", helper, theFhirContext);
        this.addExtension(match, LOQUATE_GEO_ACCURACY, "http://hapifhir.org/StructureDefinition/ext-validation-address-geo-accuracy", helper, theFhirContext);
        return (IBase)helper.getAddress();
    }

    private void addExtension(JsonNode theMatch, String theMatchField, String theExtUrl, AddressHelper theHelper, FhirContext theFhirContext) {
        String addressQuality = this.getField(theMatch, theMatchField);
        if (StringUtils.isEmpty((CharSequence)addressQuality)) {
            ourLog.debug("{} is not found in {}", (Object)theMatchField, (Object)theMatch);
            return;
        }
        IBase address = (IBase)theHelper.getAddress();
        ExtensionUtil.clearExtensionsByUrl((IBase)address, (String)theExtUrl);
        IBaseExtension addressQualityExt = ExtensionUtil.addExtension((IBase)address, (String)theExtUrl);
        addressQualityExt.setValue((IBaseDatatype)TerserUtil.newElement((FhirContext)theFhirContext, (String)"string", (Object)addressQuality));
    }

    private void toGeolocation(JsonNode theMatch, AddressHelper theHelper, FhirContext theFhirContext) {
        if (!theMatch.has("Latitude") || !theMatch.has("Longitude")) {
            ourLog.warn("Geocode is not provided in JSON {}", (Object)theMatch);
            return;
        }
        IBase address = (IBase)theHelper.getAddress();
        ExtensionUtil.clearExtensionsByUrl((IBase)address, (String)"http://hl7.org/fhir/StructureDefinition/geolocation");
        IBaseExtension geolocation = ExtensionUtil.addExtension((IBase)address, (String)"http://hl7.org/fhir/StructureDefinition/geolocation");
        IBaseExtension latitude = ExtensionUtil.addExtension((IBase)geolocation, (String)"latitude");
        latitude.setValue((IBaseDatatype)TerserUtil.newElement((FhirContext)theFhirContext, (String)"decimal", (Object)BigDecimal.valueOf(theMatch.get("Latitude").asDouble())));
        IBaseExtension longitude = ExtensionUtil.addExtension((IBase)geolocation, (String)"longitude");
        longitude.setValue((IBaseDatatype)TerserUtil.newElement((FhirContext)theFhirContext, (String)"decimal", (Object)BigDecimal.valueOf(theMatch.get("Longitude").asDouble())));
    }

    private void removeDuplicateAddressLines(JsonNode match, AddressHelper address) {
        int lineCount = 1;
        String addressLine = null;
        while ((addressLine = this.getString(match, "Address" + ++lineCount)) != null) {
            if (this.isDuplicate(addressLine, match)) continue;
            address.addLine(addressLine);
        }
    }

    private boolean isDuplicate(String theAddressLine, JsonNode theMatch) {
        for (String s : DUPLICATE_FIELDS_IN_ADDRESS_LINES) {
            JsonNode node = theMatch.get(s);
            if (node == null) continue;
            theAddressLine = theAddressLine.replaceAll(node.asText(), "");
        }
        return theAddressLine.trim().isEmpty();
    }

    @Nullable
    protected String getString(JsonNode theNode, String theField) {
        if (!theNode.has(theField)) {
            return null;
        }
        JsonNode field = theNode.get(theField);
        if (field.asText().isEmpty()) {
            return null;
        }
        String text = theNode.get(theField).asText();
        if (StringUtils.isEmpty((CharSequence)text)) {
            return "";
        }
        return text;
    }

    protected String standardize(String theText) {
        if (StringUtils.isEmpty((CharSequence)theText)) {
            return "";
        }
        Matcher m = this.myCommaPattern.matcher(theText = theText.replaceAll("\\s\\s", ", "));
        if (m.find()) {
            theText = m.replaceAll(", $1");
        }
        return theText.trim();
    }

    @Override
    protected ResponseEntity<String> getResponseEntity(IBase theAddress, FhirContext theFhirContext) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", ContentType.APPLICATION_JSON.getMimeType());
        headers.set("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        headers.set("User-Agent", "SmileCDR");
        String requestBody = this.getRequestBody(theFhirContext, theAddress);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        return this.newTemplate().postForEntity(this.getApiEndpoint(), (Object)request, String.class, new Object[0]);
    }

    @Override
    protected String getApiEndpoint() {
        String endpoint = super.getApiEndpoint();
        return StringUtils.isEmpty((CharSequence)endpoint) ? DEFAULT_DATA_CLEANSE_ENDPOINT : endpoint;
    }

    protected String getRequestBody(FhirContext theFhirContext, IBase ... theAddresses) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        if (!StringUtils.isEmpty((CharSequence)this.getApiKey())) {
            rootNode.put("Key", this.getApiKey());
        }
        rootNode.put("Geocode", this.isGeocodeEnabled());
        ArrayNode addressesArrayNode = mapper.createArrayNode();
        int i = 0;
        for (IBase address : theAddresses) {
            ourLog.debug("Converting {} out of {} addresses", (Object)i++, (Object)theAddresses.length);
            ObjectNode addressNode = this.toJsonNode(address, mapper, theFhirContext);
            addressesArrayNode.add((JsonNode)addressNode);
        }
        rootNode.set("Addresses", (JsonNode)addressesArrayNode);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
    }

    protected ObjectNode toJsonNode(IBase theAddress, ObjectMapper mapper, FhirContext theFhirContext) {
        AddressHelper helper = new AddressHelper(theFhirContext, theAddress);
        ObjectNode addressNode = mapper.createObjectNode();
        int count = 1;
        for (String s : helper.getMultiple("line")) {
            addressNode.put("Address" + count, s);
            if (++count <= 8) continue;
            break;
        }
        addressNode.put("Locality", helper.getCity());
        addressNode.put("PostalCode", helper.getPostalCode());
        addressNode.put("Country", helper.getCountry());
        return addressNode;
    }

    protected boolean isGeocodeEnabled() {
        if (!this.getProperties().containsKey(PROPERTY_GEOCODE)) {
            return false;
        }
        return Boolean.parseBoolean(this.getProperties().getProperty(PROPERTY_GEOCODE));
    }
}

