/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.mail;

import ca.uhn.fhir.rest.server.mail.IMailSvc;
import ca.uhn.fhir.rest.server.mail.MailConfig;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.simplejavamail.MailException;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.mailer.MailerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSvc
implements IMailSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(MailSvc.class);
    private final MailConfig myMailConfig;
    private final Mailer myMailer;

    public MailSvc(@Nonnull MailConfig theMailConfig) {
        Objects.requireNonNull(theMailConfig);
        this.myMailConfig = theMailConfig;
        this.myMailer = this.makeMailer(this.myMailConfig);
    }

    @Override
    public void sendMail(@Nonnull List<Email> theEmails) {
        Objects.requireNonNull(theEmails);
        theEmails.forEach(theEmail -> this.send((Email)theEmail, new OnSuccess((Email)theEmail), new ErrorHandler((Email)theEmail)));
    }

    @Override
    public void sendMail(@Nonnull Email theEmail) {
        this.send(theEmail, new OnSuccess(theEmail), new ErrorHandler(theEmail));
    }

    @Override
    public void sendMail(@Nonnull Email theEmail, @Nonnull Runnable theOnSuccess, @Nonnull Consumer<Throwable> theErrorHandler) {
        this.send(theEmail, theOnSuccess, theErrorHandler);
    }

    private void send(@Nonnull Email theEmail, @Nonnull Runnable theOnSuccess, @Nonnull Consumer<Throwable> theErrorHandler) {
        Objects.requireNonNull(theEmail);
        Objects.requireNonNull(theOnSuccess);
        Objects.requireNonNull(theErrorHandler);
        try {
            this.myMailer.sendMail(theEmail, true).whenComplete((result, ex) -> {
                if (ex != null) {
                    theErrorHandler.accept((Throwable)ex);
                } else {
                    theOnSuccess.run();
                }
            });
        }
        catch (MailException e) {
            theErrorHandler.accept(e);
        }
    }

    @Nonnull
    private Mailer makeMailer(@Nonnull MailConfig theMailConfig) {
        ourLog.info("SMTP Mailer config Hostname:[{}] | Port:[{}] | Username:[{}] | TLS:[{}]", new Object[]{theMailConfig.getSmtpHostname(), theMailConfig.getSmtpPort(), theMailConfig.getSmtpUsername(), theMailConfig.isSmtpUseStartTLS()});
        return MailerBuilder.withSMTPServer((String)theMailConfig.getSmtpHostname(), (Integer)theMailConfig.getSmtpPort(), (String)theMailConfig.getSmtpUsername(), (String)theMailConfig.getSmtpPassword()).withTransportStrategy(theMailConfig.isSmtpUseStartTLS() ? TransportStrategy.SMTP_TLS : TransportStrategy.SMTP).buildMailer();
    }

    @Nonnull
    private String makeMessage(@Nonnull Email theEmail) {
        return " with subject [" + theEmail.getSubject() + "] and recipients [" + theEmail.getRecipients().stream().map(Recipient::getAddress).collect(Collectors.joining(",")) + "]";
    }

    private class OnSuccess
    implements Runnable {
        private final Email myEmail;

        private OnSuccess(Email theEmail) {
            this.myEmail = theEmail;
        }

        @Override
        public void run() {
            ourLog.info("Email sent" + MailSvc.this.makeMessage(this.myEmail));
        }
    }

    private class ErrorHandler
    implements Consumer<Throwable> {
        private final Email myEmail;

        private ErrorHandler(Email theEmail) {
            this.myEmail = theEmail;
        }

        @Override
        public void accept(Throwable t) {
            ourLog.error("Email not sent" + MailSvc.this.makeMessage(this.myEmail), t);
        }
    }
}

