/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.messaging;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import ca.uhn.fhir.rest.server.messaging.IResourceMessage;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public abstract class BaseResourceModifiedMessage
extends BaseResourceMessage
implements IResourceMessage,
IModelJson {
    @JsonProperty(value="payload")
    protected String myPayload;
    @JsonProperty(value="payloadId")
    protected String myPayloadId;
    @JsonProperty(value="partitionId")
    protected RequestPartitionId myPartitionId;
    @JsonProperty(value="payloadVersion")
    protected String myPayloadVersion;
    @JsonIgnore
    protected transient IBaseResource myPayloadDecoded;
    @JsonIgnore
    protected transient String myPayloadType;

    public BaseResourceModifiedMessage() {
    }

    public BaseResourceModifiedMessage(IIdType theIdType, BaseResourceMessage.OperationTypeEnum theOperationType) {
        this();
        this.setOperationType(theOperationType);
        this.setPayloadId(theIdType);
    }

    public BaseResourceModifiedMessage(FhirContext theFhirContext, IBaseResource theResource, BaseResourceMessage.OperationTypeEnum theOperationType) {
        this();
        this.setOperationType(theOperationType);
        this.setNewPayload(theFhirContext, theResource);
    }

    public BaseResourceModifiedMessage(FhirContext theFhirContext, IBaseResource theNewResource, BaseResourceMessage.OperationTypeEnum theOperationType, RequestDetails theRequest) {
        this(theFhirContext, theNewResource, theOperationType);
        if (theRequest != null) {
            this.setTransactionId(theRequest.getTransactionGuid());
        }
    }

    public BaseResourceModifiedMessage(FhirContext theFhirContext, IBaseResource theNewResource, BaseResourceMessage.OperationTypeEnum theOperationType, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        this(theFhirContext, theNewResource, theOperationType);
        if (theRequest != null) {
            this.setTransactionId(theRequest.getTransactionGuid());
        }
        this.myPartitionId = theRequestPartitionId;
    }

    @Override
    public String getPayloadId() {
        return this.myPayloadId;
    }

    public String getPayloadVersion() {
        return this.myPayloadVersion;
    }

    public void setPayloadId(IIdType thePayloadId) {
        this.myPayloadId = null;
        if (thePayloadId != null) {
            this.myPayloadId = thePayloadId.toUnqualifiedVersionless().getValue();
            this.myPayloadVersion = thePayloadId.getVersionIdPart();
        }
    }

    public String getId() {
        return this.myPayloadId;
    }

    @Deprecated
    public void setId(IIdType theId) {
        this.setPayloadId(theId);
    }

    public IIdType getId(FhirContext theCtx) {
        return this.getPayloadId(theCtx);
    }

    public IIdType getPayloadId(FhirContext theCtx) {
        IIdType retVal = null;
        if (this.myPayloadId != null) {
            retVal = theCtx.getVersion().newIdType().setValue(this.myPayloadId).withVersion(this.myPayloadVersion);
        }
        return retVal;
    }

    @Nullable
    public IBaseResource getNewPayload(FhirContext theCtx) {
        if (this.myPayloadDecoded == null && StringUtils.isNotBlank((CharSequence)this.myPayload)) {
            this.myPayloadDecoded = theCtx.newJsonParser().parseResource(this.myPayload);
        }
        return this.myPayloadDecoded;
    }

    @Nullable
    public IBaseResource getPayload(FhirContext theCtx) {
        IBaseResource retVal = this.myPayloadDecoded;
        if (retVal == null && StringUtils.isNotBlank((CharSequence)this.myPayload)) {
            IParser parser = EncodingEnum.detectEncoding((String)this.myPayload).newParser(theCtx);
            this.myPayloadDecoded = retVal = parser.parseResource(this.myPayload);
        }
        return retVal;
    }

    @Nonnull
    public String getPayloadString() {
        if (this.myPayload != null) {
            return this.myPayload;
        }
        return "";
    }

    public void setNewPayload(FhirContext theCtx, IBaseResource thePayload) {
        assert (BaseResourceModifiedMessage.payloadContainsNoPlaceholderReferences(theCtx, thePayload));
        this.myPayload = theCtx.newJsonParser().encodeResourceToString(thePayload);
        this.setPayloadIdFromPayload(theCtx, thePayload);
    }

    private void setPayloadIdFromPayload(FhirContext theCtx, IBaseResource thePayload) {
        IIdType payloadIdType = thePayload.getIdElement().toUnqualified();
        if (!payloadIdType.hasResourceType()) {
            String resourceType = theCtx.getResourceType(thePayload);
            payloadIdType = payloadIdType.withResourceType(resourceType);
        }
        this.setPayloadId(payloadIdType);
    }

    public RequestPartitionId getPartitionId() {
        return this.myPartitionId;
    }

    public void setPartitionId(RequestPartitionId thePartitionId) {
        this.myPartitionId = thePartitionId;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("operationType", (Object)this.myOperationType).append("partitionId", (Object)this.myPartitionId).append("payloadId", (Object)this.myPayloadId).toString();
    }

    protected static boolean payloadContainsNoPlaceholderReferences(FhirContext theCtx, IBaseResource theNewPayload) {
        List refs = theCtx.newTerser().getAllResourceReferences(theNewPayload);
        for (ResourceReferenceInfo next : refs) {
            IBaseResource resource;
            String ref = next.getResourceReference().getReferenceElement().getValue();
            if (StringUtils.isBlank((CharSequence)ref) && (resource = next.getResourceReference().getResource()) != null) {
                ref = resource.getIdElement().getValue();
            }
            if (StringUtils.isNotBlank((CharSequence)ref) && !ref.startsWith("#") && ref.startsWith("urn:uuid:")) {
                throw new AssertionError((Object)(Msg.code((int)320) + "Reference at " + next.getName() + " is invalid: " + ref));
            }
        }
        return true;
    }

    @Override
    @Nullable
    public String getMessageKeyOrDefault() {
        return StringUtils.defaultString((String)super.getMessageKeyOrNull(), (String)this.myPayloadId);
    }

    public boolean hasPayloadType(FhirContext theFhirContext, @Nonnull String theResourceName) {
        if (this.myPayloadType == null) {
            this.myPayloadType = this.getPayloadType(theFhirContext);
        }
        return theResourceName.equals(this.myPayloadType);
    }

    @Nullable
    public String getPayloadType(FhirContext theFhirContext) {
        IBaseResource payload;
        String retval = null;
        IIdType payloadId = this.getPayloadId(theFhirContext);
        if (payloadId != null) {
            retval = payloadId.getResourceType();
        }
        if (StringUtils.isBlank(retval) && (payload = this.getNewPayload(theFhirContext)) != null) {
            retval = theFhirContext.getResourceType(payload);
        }
        return retval;
    }

    @Override
    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        if (!super.equals(theO)) {
            return false;
        }
        BaseResourceModifiedMessage that = (BaseResourceModifiedMessage)theO;
        return Objects.equals(this.myPayload, that.myPayload) && Objects.equals(this.getPayloadId(), that.getPayloadId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myPayload, this.getPayloadId());
    }
}

