/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.messaging.json;

import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.server.messaging.json.HapiMessageHeaders;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public abstract class BaseJsonMessage<T>
implements Message<T>,
IModelJson {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="headers")
    private HapiMessageHeaders myHeaders;

    public BaseJsonMessage() {
        this.setDefaultRetryHeaders();
    }

    protected void setDefaultRetryHeaders() {
        HapiMessageHeaders messageHeaders = new HapiMessageHeaders();
        this.setHeaders(messageHeaders);
    }

    public MessageHeaders getHeaders() {
        return this.myHeaders.toMessageHeaders();
    }

    public HapiMessageHeaders getHapiHeaders() {
        if (Objects.isNull(this.myHeaders)) {
            this.setDefaultRetryHeaders();
        }
        return this.myHeaders;
    }

    public void setHeaders(HapiMessageHeaders theHeaders) {
        this.myHeaders = theHeaders;
    }

    @Deprecated
    @Nullable
    public String getMessageKeyOrNull() {
        return this.getMessageKey();
    }

    @Nullable
    public String getMessageKey() {
        return null;
    }

    @Nullable
    public String getMessageKeyOrDefault() {
        return StringUtils.defaultString((String)this.getMessageKey(), (String)this.getMessageKeyDefaultValue());
    }

    @Nullable
    protected String getMessageKeyDefaultValue() {
        return null;
    }
}

