/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.method.RequestedPage;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class ResponseBundleRequest {
    public final IRestfulServer<?> server;
    public final IBundleProvider bundleProvider;
    public final RequestDetails requestDetails;
    public final int offset;
    public final String linkSelf;
    public final Set<Include> includes;
    public final BundleTypeEnum bundleType;
    public final String searchId;
    public final RequestedPage requestedPage;

    public ResponseBundleRequest(IRestfulServer<?> theServer, IBundleProvider theBundleProvider, RequestDetails theRequest, int theOffset, Integer theLimit, String theLinkSelf, Set<Include> theIncludes, BundleTypeEnum theBundleType, String theSearchId) {
        this.server = theServer;
        this.bundleProvider = theBundleProvider;
        this.requestDetails = theRequest;
        this.offset = theOffset;
        this.linkSelf = theLinkSelf;
        this.includes = theIncludes;
        this.bundleType = theBundleType;
        this.searchId = theSearchId;
        this.requestedPage = this.getRequestedPage(theLimit);
    }

    public Map<String, String[]> getRequestParameters() {
        return this.requestDetails.getParameters();
    }

    private RequestedPage getRequestedPage(Integer theLimit) {
        if (this.bundleProvider.getCurrentPageOffset() != null) {
            Validate.notNull((Object)this.bundleProvider.getCurrentPageSize(), (String)"IBundleProvider returned a non-null offset, but did not return a non-null page size", (Object[])new Object[0]);
            return new RequestedPage(this.bundleProvider.getCurrentPageOffset(), this.bundleProvider.getCurrentPageSize());
        }
        Integer parameterOffset = RestfulServerUtils.tryToExtractNamedParameter(this.requestDetails, "_offset");
        return new RequestedPage(parameterOffset, theLimit);
    }
}

