/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.servlet;

import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ServletSubRequestDetails
extends ServletRequestDetails {
    private final ServletRequestDetails myWrap;
    private final ListMultimap<String, String> myHeaders = MultimapBuilder.treeKeys((Comparator)String.CASE_INSENSITIVE_ORDER).arrayListValues().build();

    public ServletSubRequestDetails(@Nonnull ServletRequestDetails theRequestDetails) {
        super(theRequestDetails.getInterceptorBroadcaster());
        this.myWrap = theRequestDetails;
        Map<String, List<String>> headers = theRequestDetails.getHeaders();
        for (Map.Entry<String, List<String>> next : headers.entrySet()) {
            this.myHeaders.putAll((Object)next.getKey(), (Iterable)next.getValue());
        }
    }

    @Override
    public HttpServletRequest getServletRequest() {
        return this.myWrap.getServletRequest();
    }

    @Override
    public HttpServletResponse getServletResponse() {
        return this.myWrap.getServletResponse();
    }

    @Override
    public void addHeader(String theName, String theValue) {
        this.myHeaders.put((Object)theName, (Object)theValue);
    }

    @Override
    public String getHeader(String theName) {
        List list = this.myHeaders.get((Object)theName);
        if (list.isEmpty()) {
            return null;
        }
        return (String)list.get(0);
    }

    @Override
    public List<String> getHeaders(String theName) {
        List list = this.myHeaders.get((Object)theName.toLowerCase());
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    @Override
    public Map<Object, Object> getUserData() {
        return this.myWrap.getUserData();
    }

    @Override
    public boolean isSubRequest() {
        return true;
    }
}

