/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.spring.boot.autoconfigure;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jaxrs.server.AbstractJaxRsProvider;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.config.BaseJavaConfigDstu2;
import ca.uhn.fhir.jpa.config.BaseJavaConfigDstu3;
import ca.uhn.fhir.jpa.config.BaseJavaConfigR4;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.provider.BaseJpaProvider;
import ca.uhn.fhir.jpa.provider.BaseJpaSystemProvider;
import ca.uhn.fhir.jpa.subscription.channel.config.SubscriptionChannelConfig;
import ca.uhn.fhir.jpa.subscription.match.config.SubscriptionProcessorConfig;
import ca.uhn.fhir.jpa.subscription.submit.config.SubscriptionSubmitterConfig;
import ca.uhn.fhir.okhttp.client.OkHttpRestfulClientFactory;
import ca.uhn.fhir.rest.client.apache.ApacheRestfulClientFactory;
import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import ca.uhn.fhir.rest.server.HardcodedServerAddressStrategy;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.IServerAddressStrategy;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.interceptor.RequestValidatingInterceptor;
import ca.uhn.fhir.rest.server.interceptor.ResponseValidatingInterceptor;
import ca.uhn.fhir.spring.boot.autoconfigure.FhirProperties;
import ca.uhn.fhir.spring.boot.autoconfigure.FhirRestfulServerCustomizer;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.sql.DataSource;
import okhttp3.OkHttpClient;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ResourceCondition;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.CollectionUtils;

@Configuration
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
@EnableConfigurationProperties(value={FhirProperties.class})
public class FhirAutoConfiguration {
    private final FhirProperties properties;

    public FhirAutoConfiguration(FhirProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public FhirContext fhirContext() {
        FhirContext fhirContext = new FhirContext(this.properties.getVersion());
        return fhirContext;
    }

    @Configuration
    @ConditionalOnProperty(value={"hapi.fhir.server.url"})
    @EnableConfigurationProperties(value={FhirProperties.class})
    static class FhirRestfulClientConfiguration {
        private final FhirProperties properties;
        private final List<IClientInterceptor> clientInterceptors;

        public FhirRestfulClientConfiguration(FhirProperties properties, ObjectProvider<List<IClientInterceptor>> clientInterceptors) {
            this.properties = properties;
            this.clientInterceptors = (List)clientInterceptors.getIfAvailable();
        }

        @Bean
        @ConditionalOnBean(value={IRestfulClientFactory.class})
        public IGenericClient fhirClient(IRestfulClientFactory clientFactory) {
            IGenericClient fhirClient = clientFactory.newGenericClient(this.properties.getServer().getUrl());
            if (!CollectionUtils.isEmpty(this.clientInterceptors)) {
                for (IClientInterceptor interceptor : this.clientInterceptors) {
                    fhirClient.registerInterceptor((Object)interceptor);
                }
            }
            return fhirClient;
        }

        @Configuration
        @ConditionalOnClass(value={OkHttpClient.class})
        static class OkHttp {
            private final FhirContext context;

            public OkHttp(FhirContext context) {
                this.context = context;
            }

            @Bean
            @ConditionalOnMissingBean
            @ConfigurationProperties(value="hapi.fhir.rest.client.okhttp")
            public IRestfulClientFactory fhirRestfulClientFactory() {
                OkHttpRestfulClientFactory restfulClientFactory = new OkHttpRestfulClientFactory(this.context);
                return restfulClientFactory;
            }
        }

        @Configuration
        @ConditionalOnClass(value={HttpClient.class})
        @ConditionalOnMissingClass(value={"okhttp3.OkHttpClient"})
        static class Apache {
            private final FhirContext context;

            public Apache(FhirContext context) {
                this.context = context;
            }

            @Bean
            @ConditionalOnMissingBean
            @ConfigurationProperties(value="hapi.fhir.rest.client.apache")
            public IRestfulClientFactory fhirRestfulClientFactory() {
                ApacheRestfulClientFactory restfulClientFactory = new ApacheRestfulClientFactory(this.context);
                return restfulClientFactory;
            }
        }
    }

    @Configuration
    @Conditional(value={SchemaAvailableCondition.class})
    @ConditionalOnProperty(name={"hapi.fhir.validation.enabled"}, matchIfMissing=true)
    static class FhirValidationConfiguration {
        FhirValidationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RequestValidatingInterceptor requestValidatingInterceptor() {
            return new RequestValidatingInterceptor();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(name={"hapi.fhir.validation.request-only"}, havingValue="false")
        public ResponseValidatingInterceptor responseValidatingInterceptor() {
            return new ResponseValidatingInterceptor();
        }

        static class SchemaAvailableCondition
        extends ResourceCondition {
            SchemaAvailableCondition() {
                super("ValidationSchema", "hapi.fhir.validation", new String[]{"schema-location", "classpath:/org/hl7/fhir/instance/model/schema", "classpath:/org/hl7/fhir/dstu2016may/model/schema", "classpath:/org/hl7/fhir/dstu3/model/schema"});
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={BaseJpaProvider.class})
    @ConditionalOnBean(value={DataSource.class})
    @EnableConfigurationProperties(value={FhirProperties.class})
    static class FhirJpaServerConfiguration {
        @Autowired
        private ScheduledExecutorService myScheduledExecutorService;

        FhirJpaServerConfiguration() {
        }

        @Configuration
        @ConditionalOnMissingBean(type={"ca.uhn.fhir.jpa.config.BaseConfig"})
        @ConditionalOnProperty(name={"hapi.fhir.version"}, havingValue="R4")
        static class R4
        extends BaseJavaConfigR4 {
            R4() {
            }
        }

        @Configuration
        @ConditionalOnMissingBean(type={"ca.uhn.fhir.jpa.config.BaseConfig"})
        @ConditionalOnProperty(name={"hapi.fhir.version"}, havingValue="DSTU2")
        static class Dstu2
        extends BaseJavaConfigDstu2 {
            Dstu2() {
            }
        }

        @Configuration
        @ConditionalOnMissingBean(type={"ca.uhn.fhir.jpa.config.BaseConfig"})
        @ConditionalOnProperty(name={"hapi.fhir.version"}, havingValue="DSTU3")
        static class Dstu3
        extends BaseJavaConfigDstu3 {
            Dstu3() {
            }
        }

        @Configuration
        @ConditionalOnBean(value={DaoConfig.class, RestfulServer.class})
        static class RestfulServerCustomizer
        implements FhirRestfulServerCustomizer {
            private final BaseJpaSystemProvider systemProviders;

            public RestfulServerCustomizer(ObjectProvider<BaseJpaSystemProvider> systemProviders) {
                this.systemProviders = (BaseJpaSystemProvider)systemProviders.getIfAvailable();
            }

            @Override
            public void customize(RestfulServer server) {
                server.setPlainProviders(new Object[]{this.systemProviders});
            }
        }

        @Configuration
        @EntityScan(basePackages={"ca.uhn.fhir.jpa.entity", "ca.uhn.fhir.jpa.model.entity"})
        @Import(value={SubscriptionChannelConfig.class, SubscriptionProcessorConfig.class, SubscriptionSubmitterConfig.class})
        static class FhirJpaDaoConfiguration {
            FhirJpaDaoConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean
            @ConfigurationProperties(value="hapi.fhir.jpa")
            public DaoConfig fhirDaoConfig() {
                DaoConfig fhirDaoConfig = new DaoConfig();
                return fhirDaoConfig;
            }

            @Bean
            @ConditionalOnMissingBean
            @ConfigurationProperties(value="hapi.fhir.jpa")
            public PartitionSettings partitionSettings() {
                return new PartitionSettings();
            }

            @Bean
            @ConditionalOnMissingBean
            @ConfigurationProperties(value="hapi.fhir.jpa")
            public ModelConfig fhirModelConfig() {
                return this.fhirDaoConfig().getModelConfig();
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={AbstractJaxRsProvider.class})
    @EnableConfigurationProperties(value={FhirProperties.class})
    @ConfigurationProperties(value="hapi.fhir.rest")
    static class FhirRestfulServerConfiguration
    extends RestfulServer {
        private final FhirProperties properties;
        private final FhirContext fhirContext;
        private final List<IResourceProvider> resourceProviders;
        private final IPagingProvider pagingProvider;
        private final List<FhirRestfulServerCustomizer> customizers;

        public FhirRestfulServerConfiguration(FhirProperties properties, FhirContext fhirContext, ObjectProvider<List<IResourceProvider>> resourceProviders, ObjectProvider<IPagingProvider> pagingProvider, ObjectProvider<List<IServerInterceptor>> interceptors, ObjectProvider<List<FhirRestfulServerCustomizer>> customizers) {
            this.properties = properties;
            this.fhirContext = fhirContext;
            this.resourceProviders = (List)resourceProviders.getIfAvailable();
            this.pagingProvider = (IPagingProvider)pagingProvider.getIfAvailable();
            this.customizers = (List)customizers.getIfAvailable();
        }

        private void customize() {
            if (this.customizers != null) {
                AnnotationAwareOrderComparator.sort(this.customizers);
                for (FhirRestfulServerCustomizer customizer : this.customizers) {
                    customizer.customize(this);
                }
            }
        }

        @Bean
        public ServletRegistrationBean fhirServerRegistrationBean() {
            ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)this, new String[]{this.properties.getServer().getPath()});
            registration.setLoadOnStartup(1);
            return registration;
        }

        protected void initialize() throws ServletException {
            super.initialize();
            this.setFhirContext(this.fhirContext);
            this.setResourceProviders(this.resourceProviders);
            this.setPagingProvider(this.pagingProvider);
            this.setServerAddressStrategy((IServerAddressStrategy)new HardcodedServerAddressStrategy(this.properties.getServer().getPath()));
            this.customize();
        }
    }
}

