/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.HapiMigrationException;
import ca.uhn.fhir.jpa.migrate.HapiMigrationStorageSvc;
import ca.uhn.fhir.jpa.migrate.entity.HapiMigrationEntity;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HapiMigrationLock
implements AutoCloseable {
    public static final Integer LOCK_PID = -100;
    private static final Logger ourLog = LoggerFactory.getLogger(HapiMigrationLock.class);
    public static final int SLEEP_MILLIS_BETWEEN_LOCK_RETRIES = 1000;
    public static final int DEFAULT_MAX_RETRY_ATTEMPTS = 50;
    public static int ourMaxRetryAttempts = 50;
    public static final String CLEAR_LOCK_TABLE_WITH_DESCRIPTION = "CLEAR_LOCK_TABLE_WITH_DESCRIPTION";
    private final String myLockDescription = UUID.randomUUID().toString();
    private final HapiMigrationStorageSvc myMigrationStorageSvc;

    public HapiMigrationLock(HapiMigrationStorageSvc theMigrationStorageSvc) {
        this.myMigrationStorageSvc = theMigrationStorageSvc;
        this.lock();
    }

    private void lock() {
        this.cleanLockTableIfRequested();
        int retryCount = 0;
        do {
            try {
                if (this.insertLockingRow()) {
                    return;
                }
                if (++retryCount >= ourMaxRetryAttempts) continue;
                ourLog.info("Waiting for lock on {}.  Retry {}/{}", new Object[]{this.myMigrationStorageSvc.getMigrationTablename(), retryCount, ourMaxRetryAttempts});
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (retryCount < ourMaxRetryAttempts);
        String message = "Unable to obtain table lock - another database migration may be running.  If no other database migration is running, then the previous migration did not shut down properly and the lock record needs to be deleted manually.  The lock record is located in the " + this.myMigrationStorageSvc.getMigrationTablename() + " table with INSTALLED_RANK = " + LOCK_PID;
        Optional<HapiMigrationEntity> otherLockFound = this.myMigrationStorageSvc.findFirstByPidAndNotDescription(LOCK_PID, this.myLockDescription);
        if (otherLockFound.isPresent()) {
            message = message + " and DESCRIPTION = " + otherLockFound.get().getDescription();
        }
        throw new HapiMigrationException(Msg.code((int)2153) + message);
    }

    boolean cleanLockTableIfRequested() {
        String description = System.getProperty(CLEAR_LOCK_TABLE_WITH_DESCRIPTION);
        if (StringUtils.isBlank((CharSequence)description)) {
            description = System.getenv(CLEAR_LOCK_TABLE_WITH_DESCRIPTION);
        }
        if (StringUtils.isBlank((CharSequence)description)) {
            return false;
        }
        ourLog.info("Repairing lock table.  Removing row in " + this.myMigrationStorageSvc.getMigrationTablename() + " with INSTALLED_RANK = " + LOCK_PID + " and DESCRIPTION = " + description);
        boolean result = this.myMigrationStorageSvc.deleteLockRecord(description);
        if (result) {
            ourLog.info("Successfully removed lock record");
        } else {
            ourLog.info("No lock record found");
        }
        return result;
    }

    private boolean insertLockingRow() {
        try {
            boolean storedSuccessfully = this.myMigrationStorageSvc.insertLockRecord(this.myLockDescription);
            if (storedSuccessfully) {
                ourLog.info("Migration Lock Row added. [uuid={}]", (Object)this.myLockDescription);
            }
            return storedSuccessfully;
        }
        catch (Exception e) {
            ourLog.debug("Failed to insert lock record: {}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public void close() {
        boolean result = this.myMigrationStorageSvc.deleteLockRecord(this.myLockDescription);
        if (!result) {
            ourLog.error("Failed to delete migration lock record for description = [{}]", (Object)this.myLockDescription);
        }
    }

    public static void setMaxRetryAttempts(int theMaxRetryAttempts) {
        ourMaxRetryAttempts = theMaxRetryAttempts;
    }
}

