/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate;

import ca.uhn.fhir.i18n.Msg;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class MigrationJdbcUtils {
    private static final Logger ourLog = LoggerFactory.getLogger(MigrationJdbcUtils.class);

    public static boolean queryForSingleBooleanResultMultipleThrowsException(String theSql, JdbcTemplate theJdbcTemplate) {
        RowMapper booleanRowMapper = (theResultSet, theRowNumber) -> theResultSet.getBoolean(1);
        return MigrationJdbcUtils.queryForSingle(theSql, theJdbcTemplate, booleanRowMapper).orElse(false);
    }

    private static <T> Optional<T> queryForSingle(String theSql, JdbcTemplate theJdbcTemplate, RowMapper<T> theRowMapper) {
        List<T> results = MigrationJdbcUtils.queryForMultiple(theSql, theJdbcTemplate, theRowMapper);
        if (results.isEmpty()) {
            return Optional.empty();
        }
        if (results.size() > 1) {
            throw new IllegalArgumentException(Msg.code((int)2474) + String.format("Failure due to query returning more than one result: %s for SQL: [%s].", results, theSql));
        }
        return Optional.ofNullable(results.get(0));
    }

    private static <T> List<T> queryForMultiple(String theSql, JdbcTemplate theJdbcTemplate, RowMapper<T> theRowMapper) {
        return theJdbcTemplate.query(theSql, theRowMapper);
    }
}

