/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableColumnTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnDriverMappingOverride;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnNameCase;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnTypeEnum;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class BaseTableColumnTypeTask
extends BaseTableColumnTask {
    private ColumnTypeEnum myColumnType;
    private Boolean myNullable;
    private Long myColumnLength;
    @Nullable
    private Object myDefaultValue;

    public BaseTableColumnTypeTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    BaseTableColumnTypeTask(String theProductVersion, String theSchemaVersion, ColumnNameCase theColumnNameCase, Set<ColumnDriverMappingOverride> theColumnDriverMappingOverrides) {
        super(theProductVersion, theSchemaVersion, theColumnNameCase, theColumnDriverMappingOverrides);
    }

    public ColumnTypeEnum getColumnType() {
        return this.myColumnType;
    }

    public BaseTableColumnTask setColumnType(ColumnTypeEnum theColumnType) {
        this.myColumnType = theColumnType;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        Validate.notNull((Object)((Object)this.myColumnType));
        Validate.notNull((Object)this.myNullable);
        if (this.myColumnType == ColumnTypeEnum.STRING) {
            Validate.notNull((Object)this.myColumnLength, (String)("No length specified for " + ColumnTypeEnum.STRING + " column " + this.getColumnName()), (Object[])new Object[0]);
        } else {
            Validate.isTrue((this.myColumnLength == null ? 1 : 0) != 0);
        }
    }

    protected String getSqlType() {
        return this.getSqlType(this.getColumnLength());
    }

    protected String getSqlType(Long theColumnLength) {
        return this.getSqlType(this.myColumnType, theColumnLength);
    }

    public boolean isNullable() {
        return this.myNullable;
    }

    public BaseTableColumnTask setNullable(boolean theNullable) {
        this.myNullable = theNullable;
        return this;
    }

    protected String getSqlNotNull() {
        return this.isNullable() ? " null " : " not null";
    }

    public Long getColumnLength() {
        return this.myColumnLength;
    }

    public BaseTableColumnTypeTask setColumnLength(long theColumnLength) {
        this.myColumnLength = theColumnLength;
        return this;
    }

    @Nullable
    public Object getDefaultValue() {
        return this.myDefaultValue;
    }

    @Nonnull
    String buildString(@Nullable Object theValue, Function<Object, String> doIfNull, String theDefaultResult) {
        return Optional.ofNullable(theValue).map(doIfNull).orElse(theDefaultResult);
    }

    public BaseTableColumnTypeTask setDefaultValue(Object theDefaultValue) {
        this.myDefaultValue = theDefaultValue;
        return this;
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        super.generateHashCode(theBuilder);
        theBuilder.append(this.getColumnTypeName(this.myColumnType));
        theBuilder.append((Object)this.myNullable);
        theBuilder.append((Object)this.myColumnLength);
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        BaseTableColumnTypeTask otherObject = (BaseTableColumnTypeTask)theOtherObject;
        super.generateEquals(theBuilder, otherObject);
        theBuilder.append(this.getColumnTypeName(this.myColumnType), this.getColumnTypeName(otherObject.myColumnType));
        theBuilder.append((Object)this.myNullable, (Object)otherObject.myNullable);
        theBuilder.append((Object)this.myColumnLength, (Object)otherObject.myColumnLength);
    }

    @Nullable
    private Object getColumnTypeName(ColumnTypeEnum theColumnType) {
        if (theColumnType == null) {
            return null;
        }
        return this.myColumnType.name();
    }
}

