/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.HapiMigrationException;
import ca.uhn.fhir.jpa.migrate.taskdef.ExecuteTaskPrecondition;
import ca.uhn.fhir.jpa.migrate.tasks.api.TaskFlagEnum;
import ca.uhn.fhir.system.HapiSystemProperties;
import jakarta.annotation.Nonnull;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.flywaydb.core.api.MigrationVersion;
import org.intellij.lang.annotations.Language;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class BaseTask {
    public static final String MIGRATION_VERSION_PATTERN = "\\d{8}\\.\\d+";
    private static final Logger ourLog = LoggerFactory.getLogger(BaseTask.class);
    private static final Pattern versionPattern = Pattern.compile("\\d{8}\\.\\d+");
    private final String myProductVersion;
    private final String mySchemaVersion;
    private final List<ExecuteTaskPrecondition> myPreconditions = new ArrayList<ExecuteTaskPrecondition>();
    private final EnumSet<TaskFlagEnum> myFlags = EnumSet.noneOf(TaskFlagEnum.class);
    private final List<ExecutedStatement> myExecutedStatements = new ArrayList<ExecutedStatement>();
    protected boolean myCheckForExistingTables = true;
    protected boolean myPrettyPrint = false;
    private DriverTypeEnum.ConnectionProperties myConnectionProperties;
    private DriverTypeEnum myDriverType;
    private String myDescription;
    private Integer myChangesCount = 0;
    private boolean myDryRun;
    private boolean myTransactional = true;
    private Set<DriverTypeEnum> myOnlyAppliesToPlatforms = new HashSet<DriverTypeEnum>();
    private boolean myNoColumnShrink;

    protected BaseTask(String theProductVersion, String theSchemaVersion) {
        this.myProductVersion = theProductVersion;
        this.mySchemaVersion = theSchemaVersion;
    }

    public BaseTask addFlag(@Nonnull TaskFlagEnum theFlag) {
        this.myFlags.add(theFlag);
        return this;
    }

    public void setTransactional(boolean theTransactional) {
        this.myTransactional = theTransactional;
    }

    public void setPrettyPrint(boolean thePrettyPrint) {
        this.myPrettyPrint = thePrettyPrint;
    }

    public void setOnlyAppliesToPlatforms(Set<DriverTypeEnum> theOnlyAppliesToPlatforms) {
        Validate.notNull(theOnlyAppliesToPlatforms, (String)"theOnlyAppliesToPlatforms must not be null", (Object[])new Object[0]);
        this.myOnlyAppliesToPlatforms = theOnlyAppliesToPlatforms;
    }

    public String getProductVersion() {
        return this.myProductVersion;
    }

    public String getSchemaVersion() {
        return this.mySchemaVersion;
    }

    public boolean isNoColumnShrink() {
        return this.myNoColumnShrink;
    }

    public void setNoColumnShrink(boolean theNoColumnShrink) {
        this.myNoColumnShrink = theNoColumnShrink;
    }

    public boolean isDryRun() {
        return this.myDryRun;
    }

    public void setDryRun(boolean theDryRun) {
        this.myDryRun = theDryRun;
    }

    public String getDescription() {
        if (this.myDescription == null) {
            return this.getClass().getSimpleName();
        }
        return this.myDescription;
    }

    public BaseTask setDescription(String theDescription) {
        this.myDescription = theDescription;
        return this;
    }

    public List<ExecutedStatement> getExecutedStatements() {
        return this.myExecutedStatements;
    }

    public int getChangesCount() {
        return this.myChangesCount;
    }

    public void executeSql(String theTableName, @Language(value="SQL") String theSql, Object ... theArguments) {
        if (!this.isDryRun()) {
            Integer changes = this.myTransactional ? (Integer)this.getConnectionProperties().getTxTemplate().execute(t -> this.doExecuteSql(theSql, theArguments)) : Integer.valueOf(this.doExecuteSql(theSql, theArguments));
            this.myChangesCount = this.myChangesCount + changes;
        }
        this.captureExecutedStatement(theTableName, theSql, theArguments);
    }

    protected void executeSqlListInTransaction(String theTableName, List<String> theSqlStatements) {
        if (!this.isDryRun()) {
            Integer changes = (Integer)this.getConnectionProperties().getTxTemplate().execute(t -> this.doExecuteSqlList(theSqlStatements));
            this.myChangesCount = this.myChangesCount + changes;
        }
        for (String sqlStatement : theSqlStatements) {
            this.captureExecutedStatement(theTableName, sqlStatement, new Object[0]);
        }
    }

    private Integer doExecuteSqlList(List<String> theSqlStatements) {
        int changesCount = 0;
        for (String nextSql : theSqlStatements) {
            changesCount += this.doExecuteSql(nextSql, new Object[0]);
        }
        return changesCount;
    }

    private int doExecuteSql(@Language(value="SQL") String theSql, Object ... theArguments) {
        JdbcTemplate jdbcTemplate = this.getConnectionProperties().newJdbcTemplate();
        jdbcTemplate.setQueryTimeout(0);
        try {
            int changesCount = jdbcTemplate.update(theSql, theArguments);
            if (!HapiSystemProperties.isUnitTestModeEnabled()) {
                this.logInfo(ourLog, "SQL \"{}\" returned {}", theSql, changesCount);
            }
            return changesCount;
        }
        catch (DataAccessException e) {
            if (this.myFlags.contains((Object)TaskFlagEnum.FAILURE_ALLOWED)) {
                ourLog.info("Task {} did not exit successfully on doExecuteSql(), but task is allowed to fail", (Object)this.getMigrationVersion());
                ourLog.debug("Error was: {}", (Object)e.getMessage(), (Object)e);
                return 0;
            }
            throw new HapiMigrationException(Msg.code((int)61) + "Failed during task " + this.getMigrationVersion() + ": " + e, (Exception)((Object)e));
        }
    }

    protected void captureExecutedStatement(String theTableName, @Language(value="SQL") String theSql, Object ... theArguments) {
        this.myExecutedStatements.add(new ExecutedStatement(this.mySchemaVersion, theTableName, theSql, theArguments));
    }

    public DriverTypeEnum.ConnectionProperties getConnectionProperties() {
        return this.myConnectionProperties;
    }

    public BaseTask setConnectionProperties(DriverTypeEnum.ConnectionProperties theConnectionProperties) {
        this.myConnectionProperties = theConnectionProperties;
        return this;
    }

    public DriverTypeEnum getDriverType() {
        return this.myDriverType;
    }

    public BaseTask setDriverType(DriverTypeEnum theDriverType) {
        this.myDriverType = theDriverType;
        return this;
    }

    public abstract void validate();

    public TransactionTemplate getTxTemplate() {
        return this.getConnectionProperties().getTxTemplate();
    }

    public JdbcTemplate newJdbcTemplate() {
        return this.getConnectionProperties().newJdbcTemplate();
    }

    public void execute() throws SQLException {
        if (this.myFlags.contains((Object)TaskFlagEnum.DO_NOTHING)) {
            ourLog.info("Skipping stubbed task: {}", (Object)this.getDescription());
            return;
        }
        if (!this.myOnlyAppliesToPlatforms.isEmpty() && !this.myOnlyAppliesToPlatforms.contains((Object)this.getDriverType())) {
            ourLog.info("Skipping task {} as it does not apply to {}", (Object)this.getDescription(), (Object)this.getDriverType());
            return;
        }
        for (ExecuteTaskPrecondition precondition : this.myPreconditions) {
            ourLog.debug("precondition to evaluate: {}", (Object)precondition);
            if (precondition.getPreconditionRunner().get().booleanValue()) continue;
            ourLog.info("Skipping task since one of the preconditions was not met: {}", (Object)precondition.getPreconditionReason());
            return;
        }
        this.doExecute();
    }

    protected abstract void doExecute() throws SQLException;

    public String getMigrationVersion() {
        String releasePart = this.myProductVersion;
        if (releasePart.startsWith("V")) {
            releasePart = releasePart.substring(1);
        }
        String version = releasePart + "." + this.mySchemaVersion;
        MigrationVersion migrationVersion = MigrationVersion.fromVersion((String)version);
        return migrationVersion.getVersion();
    }

    protected void logInfo(Logger theLog, String theFormattedMessage, Object ... theArguments) {
        theLog.info(this.getMigrationVersion() + ": " + theFormattedMessage, theArguments);
    }

    public void validateVersion() {
        Matcher matcher = versionPattern.matcher(this.mySchemaVersion);
        if (!matcher.matches()) {
            throw new IllegalStateException(Msg.code((int)62) + "The version " + this.mySchemaVersion + " does not match the expected pattern \\d{8}\\.\\d+");
        }
    }

    public void addPrecondition(ExecuteTaskPrecondition thePrecondition) {
        this.myPreconditions.add(thePrecondition);
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        this.generateHashCode(builder);
        return builder.hashCode();
    }

    protected abstract void generateHashCode(HashCodeBuilder var1);

    public final boolean equals(Object theObject) {
        if (theObject == null || !this.getClass().equals(theObject.getClass())) {
            return false;
        }
        BaseTask otherObject = (BaseTask)theObject;
        EqualsBuilder b = new EqualsBuilder();
        this.generateEquals(b, otherObject);
        return b.isEquals();
    }

    protected abstract void generateEquals(EqualsBuilder var1, BaseTask var2);

    public boolean initializedSchema() {
        return false;
    }

    public boolean isDoNothing() {
        return this.myFlags.contains((Object)TaskFlagEnum.DO_NOTHING);
    }

    public boolean isHeavyweightSkippableTask() {
        return this.myFlags.contains((Object)TaskFlagEnum.HEAVYWEIGHT_SKIP_BY_DEFAULT);
    }

    public boolean hasFlag(TaskFlagEnum theFlag) {
        return this.myFlags.contains((Object)theFlag);
    }

    public static class ExecutedStatement {
        private final String mySql;
        private final List<Object> myArguments;
        private final String myTableName;
        private final String mySchemaVersion;

        public ExecutedStatement(String theSchemaVersion, String theDescription, String theSql, Object[] theArguments) {
            this.mySchemaVersion = theSchemaVersion;
            this.myTableName = theDescription;
            this.mySql = theSql;
            this.myArguments = theArguments != null ? Arrays.asList(theArguments) : Collections.emptyList();
        }

        public String getSchemaVersion() {
            return this.mySchemaVersion;
        }

        public String getTableName() {
            return this.myTableName;
        }

        public String getSql() {
            return this.mySql;
        }

        public List<Object> getArguments() {
            return this.myArguments;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("tableName", (Object)this.myTableName).append("sql", (Object)this.mySql).append("arguments", this.myArguments).toString();
        }
    }
}

