/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.tasks;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.tasks.api.ISchemaInitializationProvider;
import ca.uhn.fhir.util.ClasspathUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SchemaInitializationProvider
implements ISchemaInitializationProvider {
    private final String mySchemaExistsIndicatorTable;
    private final boolean myCanInitializeSchema;
    private String mySchemaFileClassPath;
    private String mySchemaDescription;

    public SchemaInitializationProvider(String theSchemaDescription, String theSchemaFileClassPath, String theSchemaExistsIndicatorTable, boolean theCanInitializeSchema) {
        this.mySchemaDescription = theSchemaDescription;
        this.mySchemaFileClassPath = theSchemaFileClassPath;
        this.mySchemaExistsIndicatorTable = theSchemaExistsIndicatorTable;
        this.myCanInitializeSchema = theCanInitializeSchema;
    }

    @Override
    public List<String> getSqlStatements(DriverTypeEnum theDriverType) {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        ArrayList<String> retval = new ArrayList<String>();
        String initScript = this.mySchemaFileClassPath + "/" + this.getInitScript(theDriverType);
        try {
            InputStream sqlFileInputStream = ClasspathUtil.loadResourceAsStream((String)initScript);
            String sqlString = IOUtils.toString((InputStream)sqlFileInputStream, (Charset)Charsets.UTF_8);
            this.parseSqlFileIntoIndividualStatements(theDriverType, retval, sqlString);
        }
        catch (IOException e) {
            throw new ConfigurationException(Msg.code((int)50) + "Error reading schema initialization script " + initScript, (Throwable)e);
        }
        return retval;
    }

    @VisibleForTesting
    void parseSqlFileIntoIndividualStatements(DriverTypeEnum theDriverType, List<String> retval, String theSqlString) {
        String[] statements;
        String sqlString = theSqlString.replaceAll("--.*", "");
        String sqlStringNoComments = this.preProcessSqlString(theDriverType, sqlString);
        for (String statement : statements = sqlStringNoComments.split(";")) {
            String cleanedStatement = this.preProcessSqlStatement(theDriverType, statement);
            if (StringUtils.isBlank((CharSequence)cleanedStatement)) continue;
            String next = StringUtils.trim((String)cleanedStatement);
            next = next.replace('\n', ' ');
            next = next.replace('\r', ' ');
            next = next.replaceAll(" +", " ");
            retval.add(next);
        }
    }

    protected String preProcessSqlString(DriverTypeEnum theDriverType, String sqlString) {
        return sqlString;
    }

    protected String preProcessSqlStatement(DriverTypeEnum theDriverType, String sqlStatement) {
        return sqlStatement;
    }

    @Nonnull
    protected String getInitScript(DriverTypeEnum theDriverType) {
        return theDriverType.getSchemaFilename();
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        SchemaInitializationProvider that = (SchemaInitializationProvider)theO;
        return this.getClass().getSimpleName() == that.getClass().getSimpleName();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getClass().getSimpleName()).toHashCode();
    }

    @Override
    public String getSchemaExistsIndicatorTable() {
        return this.mySchemaExistsIndicatorTable;
    }

    public SchemaInitializationProvider setSchemaFileClassPath(String theSchemaFileClassPath) {
        this.mySchemaFileClassPath = theSchemaFileClassPath;
        return this;
    }

    @Override
    public String getSchemaDescription() {
        return this.mySchemaDescription;
    }

    @Override
    public SchemaInitializationProvider setSchemaDescription(String theSchemaDescription) {
        this.mySchemaDescription = theSchemaDescription;
        return this;
    }

    @Override
    public boolean canInitializeSchema() {
        return this.myCanInitializeSchema;
    }
}

