/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.HapiMigrationException;
import ca.uhn.fhir.jpa.migrate.HapiMigrationLock;
import ca.uhn.fhir.jpa.migrate.MigrationTaskList;
import ca.uhn.fhir.jpa.migrate.dao.HapiMigrationDao;
import ca.uhn.fhir.jpa.migrate.entity.HapiMigrationEntity;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import java.util.Optional;
import java.util.Set;
import org.flywaydb.core.api.MigrationVersion;

public class HapiMigrationStorageSvc {
    public static final String UNKNOWN_VERSION = "unknown";
    public static final String LOCK_TYPE = "hapi-fhir-lock";
    private final HapiMigrationDao myHapiMigrationDao;

    public HapiMigrationStorageSvc(HapiMigrationDao theHapiMigrationDao) {
        this.myHapiMigrationDao = theHapiMigrationDao;
    }

    public String getMigrationTablename() {
        return this.myHapiMigrationDao.getMigrationTablename();
    }

    public MigrationTaskList diff(MigrationTaskList theTaskList) {
        Set<MigrationVersion> appliedMigrationVersions = this.fetchAppliedMigrationVersions();
        return theTaskList.diff(appliedMigrationVersions);
    }

    Set<MigrationVersion> fetchAppliedMigrationVersions() {
        return this.myHapiMigrationDao.fetchSuccessfulMigrationVersions();
    }

    public String getLatestAppliedVersion() {
        return this.fetchAppliedMigrationVersions().stream().sorted().map(MigrationVersion::toString).reduce((first, second) -> second).orElse(UNKNOWN_VERSION);
    }

    public void saveTask(BaseTask theBaseTask, Integer theMillis, boolean theSuccess) {
        HapiMigrationEntity entity = HapiMigrationEntity.fromBaseTask(theBaseTask);
        entity.setExecutionTime(theMillis);
        entity.setSuccess(theSuccess);
        this.myHapiMigrationDao.save(entity);
    }

    public boolean createMigrationTableIfRequired() {
        return this.myHapiMigrationDao.createMigrationTableIfRequired();
    }

    public boolean deleteLockRecord(String theLockDescription) {
        this.verifyNoOtherLocksPresent(theLockDescription);
        return this.myHapiMigrationDao.deleteLockRecord(HapiMigrationLock.LOCK_PID, theLockDescription);
    }

    void verifyNoOtherLocksPresent(String theLockDescription) {
        Optional<HapiMigrationEntity> otherLockFound = this.myHapiMigrationDao.findFirstByPidAndNotDescription(HapiMigrationLock.LOCK_PID, theLockDescription);
        if (otherLockFound.isPresent()) {
            throw new HapiMigrationException(Msg.code((int)2152) + "Internal error: on unlocking, a competing lock was found");
        }
    }

    public boolean insertLockRecord(String theLockDescription) {
        HapiMigrationEntity entity = new HapiMigrationEntity();
        entity.setPid(HapiMigrationLock.LOCK_PID);
        entity.setType(LOCK_TYPE);
        entity.setDescription(theLockDescription);
        entity.setExecutionTime(0);
        entity.setSuccess(true);
        return this.myHapiMigrationDao.save(entity);
    }

    public Optional<HapiMigrationEntity> findFirstByPidAndNotDescription(Integer theLockPid, String theLockDescription) {
        return this.myHapiMigrationDao.findFirstByPidAndNotDescription(theLockPid, theLockDescription);
    }
}

