/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.AddIndexTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import jakarta.annotation.Nonnull;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.SingleColumnRowMapper;

public class DropIndexTask
extends BaseTableTask {
    private static final Logger ourLog = LoggerFactory.getLogger(DropIndexTask.class);
    private String myIndexName;
    private boolean myOnline;

    public DropIndexTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    List<String> generateSql() throws SQLException {
        Validate.notBlank((CharSequence)this.myIndexName, (String)"indexName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.getTableName(), (String)"tableName must not be blank", (Object[])new Object[0]);
        if (!JdbcUtils.getIndexNames(this.getConnectionProperties(), this.getTableName()).contains(this.myIndexName)) {
            return Collections.emptyList();
        }
        boolean isUnique = JdbcUtils.isIndexUnique(this.getConnectionProperties(), this.getTableName(), this.myIndexName);
        return this.doGenerateSql(isUnique);
    }

    @Nonnull
    List<String> doGenerateSql(boolean isUnique) {
        DriverTypeEnum driverType = this.getDriverType();
        ArrayList<String> sql = new ArrayList<String>();
        if (isUnique) {
            switch (driverType) {
                case MYSQL_5_7: 
                case MARIADB_10_1: {
                    sql.add("alter table " + this.getTableName() + " drop index `" + this.myIndexName + "`");
                    break;
                }
                case H2_EMBEDDED: {
                    sql.add("drop index " + this.myIndexName);
                    break;
                }
                case DERBY_EMBEDDED: {
                    sql.add("alter table " + this.getTableName() + " drop constraint " + this.myIndexName);
                    break;
                }
                case ORACLE_12C: {
                    sql.add("drop index " + this.myIndexName + (this.myOnline ? " ONLINE" : ""));
                    break;
                }
                case MSSQL_2012: {
                    sql.add("drop index " + this.myIndexName + " on " + this.getTableName() + (this.myOnline ? " WITH (ONLINE = ON)" : ""));
                    break;
                }
                case POSTGRES_9_4: {
                    sql.add("alter table " + this.getTableName() + " drop constraint if exists " + this.myIndexName + " cascade");
                    sql.add("drop index " + (this.myOnline ? "CONCURRENTLY " : "") + "if exists " + this.myIndexName + " cascade");
                    this.setTransactional(!this.myOnline);
                    break;
                }
                case COCKROACHDB_21_1: {
                    sql.add("drop index if exists " + this.getTableName() + "@" + this.myIndexName + " cascade");
                }
            }
        } else {
            switch (driverType) {
                case MYSQL_5_7: 
                case MARIADB_10_1: {
                    sql.add("alter table " + this.getTableName() + " drop index " + this.myIndexName);
                    break;
                }
                case POSTGRES_9_4: {
                    sql.add("drop index " + (this.myOnline ? "CONCURRENTLY " : "") + this.myIndexName);
                    this.setTransactional(!this.myOnline);
                    break;
                }
                case H2_EMBEDDED: 
                case DERBY_EMBEDDED: {
                    sql.add("drop index " + this.myIndexName);
                    break;
                }
                case ORACLE_12C: {
                    sql.add("drop index " + this.myIndexName + (this.myOnline ? " ONLINE" : ""));
                    break;
                }
                case MSSQL_2012: {
                    Object sqlServerDrop = "drop index " + this.getTableName() + "." + this.myIndexName;
                    if (this.myOnline) {
                        sqlServerDrop = AddIndexTask.buildOnlineCreateWithTryCatchFallback((String)sqlServerDrop);
                    }
                    sql.add((String)sqlServerDrop);
                    break;
                }
                case COCKROACHDB_21_1: {
                    sql.add("drop index " + this.getTableName() + "@" + this.myIndexName);
                }
            }
        }
        return sql;
    }

    @Override
    public void validate() {
        super.validate();
        Validate.notBlank((CharSequence)this.myIndexName, (String)"The index name must not be blank", (Object[])new Object[0]);
        this.setDescription("Drop index " + this.myIndexName + " from table " + this.getTableName());
    }

    @Override
    public void doExecute() throws SQLException {
        String dropConstraintSql;
        String findConstraintSql;
        if (this.getDriverType() == DriverTypeEnum.H2_EMBEDDED) {
            findConstraintSql = "SELECT DISTINCT constraint_name FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE constraint_name = ? AND table_name = ?";
            dropConstraintSql = "ALTER TABLE " + this.getTableName() + " DROP CONSTRAINT ?";
            this.findAndDropConstraint(findConstraintSql, dropConstraintSql);
        } else if (this.getDriverType() == DriverTypeEnum.DERBY_EMBEDDED) {
            findConstraintSql = "SELECT c.constraintname FROM sys.sysconstraints c, sys.systables t WHERE c.tableid = t.tableid AND c.constraintname = ? AND t.tablename = ?";
            dropConstraintSql = "ALTER TABLE " + this.getTableName() + " DROP CONSTRAINT ?";
            this.findAndDropConstraint(findConstraintSql, dropConstraintSql);
        } else if (this.getDriverType() == DriverTypeEnum.ORACLE_12C) {
            findConstraintSql = "SELECT constraint_name FROM user_constraints WHERE constraint_name = ? AND table_name = ?";
            dropConstraintSql = "ALTER TABLE " + this.getTableName() + " DROP CONSTRAINT ?";
            this.findAndDropConstraint(findConstraintSql, dropConstraintSql);
        } else if (this.getDriverType() == DriverTypeEnum.MSSQL_2012) {
            findConstraintSql = "SELECT tc.CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS tc WHERE tc.CONSTRAINT_NAME = ? AND tc.TABLE_NAME = ?";
            dropConstraintSql = "ALTER TABLE " + this.getTableName() + " DROP CONSTRAINT ?";
            this.findAndDropConstraint(findConstraintSql, dropConstraintSql);
        }
        Set<String> indexNames = JdbcUtils.getIndexNames(this.getConnectionProperties(), this.getTableName());
        if (!indexNames.contains(this.myIndexName)) {
            this.logInfo(ourLog, "Index {} does not exist on table {} - No action needed", this.myIndexName, this.getTableName());
            return;
        }
        boolean isUnique = JdbcUtils.isIndexUnique(this.getConnectionProperties(), this.getTableName(), this.myIndexName);
        String uniquenessString = isUnique ? "unique" : "non-unique";
        List<String> sqls = this.generateSql();
        if (!sqls.isEmpty()) {
            this.logInfo(ourLog, "Dropping {} index {} on table {}", uniquenessString, this.myIndexName, this.getTableName());
        }
        for (String sql : sqls) {
            this.executeSql(this.getTableName(), sql, new Object[0]);
        }
    }

    public void findAndDropConstraint(String theFindConstraintSql, String theDropConstraintSql) {
        DataSource dataSource = Objects.requireNonNull(this.getConnectionProperties().getDataSource());
        this.getConnectionProperties().getTxTemplate().executeWithoutResult(t -> {
            JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
            RowMapperResultSetExtractor resultSetExtractor = new RowMapperResultSetExtractor((RowMapper)new SingleColumnRowMapper(String.class));
            List outcome = (List)jdbcTemplate.query(theFindConstraintSql, new Object[]{this.myIndexName, this.getTableName()}, (ResultSetExtractor)resultSetExtractor);
            assert (outcome != null);
            for (String next : outcome) {
                String sql = theDropConstraintSql.replace("?", next);
                this.executeSql(this.getTableName(), sql, new Object[0]);
            }
        });
    }

    public DropIndexTask setIndexName(String theIndexName) {
        this.myIndexName = theIndexName;
        return this;
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        DropIndexTask otherObject = (DropIndexTask)theOtherObject;
        super.generateEquals(theBuilder, otherObject);
        theBuilder.append((Object)this.myIndexName, (Object)otherObject.myIndexName);
        theBuilder.append(this.myOnline, otherObject.myOnline);
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        super.generateHashCode(theBuilder);
        theBuilder.append((Object)this.myIndexName);
        theBuilder.append(this.myOnline);
    }

    public void setOnline(boolean theFlag) {
        this.myOnline = theFlag;
    }
}

