/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnTypeEnum;
import jakarta.annotation.Nonnull;

public class ForeignKeyContainer {
    private String myParentTableName;
    private String myColumnName;
    private ColumnTypeEnum myColumnTypeEnum;
    private String myParentTableColumnName;

    public ForeignKeyContainer(String theColumnName, ColumnTypeEnum theColumnTypeEnum, String theParentTableName, String theParentTableColumnName) {
        this.myColumnName = theColumnName;
        this.myColumnTypeEnum = theColumnTypeEnum;
        this.myParentTableName = theParentTableName;
        this.myParentTableColumnName = theParentTableColumnName;
    }

    public String getParentTableName() {
        return this.myParentTableName;
    }

    public void setParentTableName(String theParentTableName) {
        this.myParentTableName = theParentTableName;
    }

    public String getColumnName() {
        return this.myColumnName;
    }

    public void setColumnName(String theColumnName) {
        this.myColumnName = theColumnName;
    }

    public String getParentTableColumnName() {
        return this.myParentTableColumnName;
    }

    public void setParentTableColumnName(String theParentTableColumnName) {
        this.myParentTableColumnName = theParentTableColumnName;
    }

    public ColumnTypeEnum getColumnTypeEnum() {
        return this.myColumnTypeEnum;
    }

    public void setColumnTypeEnum(ColumnTypeEnum theColumnTypeEnum) {
        this.myColumnTypeEnum = theColumnTypeEnum;
    }

    public String generateSQL(@Nonnull DriverTypeEnum theDriverTypeEnum, boolean thePrettyPrint) {
        switch (theDriverTypeEnum) {
            case MYSQL_5_7: {
                return String.format("FOREIGN KEY (%s) REFERENCES %s(%s)", this.myColumnName, this.myParentTableName, this.myParentTableColumnName);
            }
            case MSSQL_2012: 
            case ORACLE_12C: {
                return String.format("%s %s FOREIGN KEY REFERENCES %s(%s)", this.myColumnName, this.myColumnTypeEnum.name(), this.myParentTableName, this.myParentTableColumnName);
            }
            case POSTGRES_9_4: {
                return String.format("FOREIGN KEY(%s) REFERENCES %s(%s)", this.myColumnName, this.myParentTableName, this.myParentTableColumnName);
            }
        }
        throw new UnsupportedOperationException(Msg.code((int)2232) + " SQL Engine " + theDriverTypeEnum.name() + " not supported for foreign key!");
    }
}

