/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableColumnTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import java.sql.SQLException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddForeignKeyTask
extends BaseTableColumnTask {
    private static final Logger ourLog = LoggerFactory.getLogger(AddForeignKeyTask.class);
    private String myConstraintName;
    private String myForeignTableName;
    private String myForeignColumnName;

    public AddForeignKeyTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    public void setConstraintName(String theConstraintName) {
        this.myConstraintName = theConstraintName;
    }

    public void setForeignTableName(String theForeignTableName) {
        this.myForeignTableName = theForeignTableName;
    }

    public void setForeignColumnName(String theForeignColumnName) {
        this.myForeignColumnName = theForeignColumnName;
    }

    @Override
    public void validate() {
        super.validate();
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.myConstraintName));
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.myForeignTableName));
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.myForeignColumnName));
        this.setDescription("Add foreign key " + this.myConstraintName + " from column " + this.getColumnName() + " of table " + this.getTableName() + " to column " + this.myForeignColumnName + " of table " + this.myForeignTableName);
    }

    @Override
    public void doExecute() throws SQLException {
        String sql;
        Set<String> existing = JdbcUtils.getForeignKeys(this.getConnectionProperties(), this.myForeignTableName, this.getTableName());
        if (existing.contains(this.myConstraintName)) {
            this.logInfo(ourLog, "Already have constraint named {} - No action performed", this.myConstraintName);
            return;
        }
        switch (this.getDriverType()) {
            case MARIADB_10_1: 
            case MYSQL_5_7: {
                sql = "alter table " + this.getTableName() + " add constraint " + this.myConstraintName + " foreign key (`" + this.getColumnName() + "`) references " + this.myForeignTableName + " (`" + this.myForeignColumnName + "`)";
                break;
            }
            case COCKROACHDB_21_1: 
            case POSTGRES_9_4: 
            case DERBY_EMBEDDED: 
            case H2_EMBEDDED: 
            case ORACLE_12C: 
            case MSSQL_2012: {
                sql = "alter table " + this.getTableName() + " add constraint " + this.myConstraintName + " foreign key (" + this.getColumnName() + ") references " + this.myForeignTableName;
                break;
            }
            default: {
                throw new IllegalStateException(Msg.code((int)68));
            }
        }
        try {
            this.executeSql(this.getTableName(), sql, new Object[0]);
        }
        catch (Exception e) {
            if (e.toString().contains("already exists")) {
                ourLog.warn("Index {} already exists", (Object)this.myConstraintName);
            }
            throw e;
        }
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        super.generateHashCode(theBuilder);
        theBuilder.append((Object)this.myConstraintName);
        theBuilder.append((Object)this.myForeignTableName);
        theBuilder.append((Object)this.myForeignColumnName);
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        AddForeignKeyTask otherObject = (AddForeignKeyTask)theOtherObject;
        super.generateEquals(theBuilder, otherObject);
        theBuilder.append((Object)this.myConstraintName, (Object)otherObject.myConstraintName);
        theBuilder.append((Object)this.myForeignTableName, (Object)otherObject.myForeignTableName);
        theBuilder.append((Object)this.myForeignColumnName, (Object)otherObject.myForeignColumnName);
    }
}

