/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import jakarta.annotation.Nonnull;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddPrimaryKeyTask
extends BaseTableTask {
    private static final Logger ourLog = LoggerFactory.getLogger(AddPrimaryKeyTask.class);
    private final List<String> myPrimaryKeyColumnsInOrder;

    public AddPrimaryKeyTask(String theProductVersion, String theSchemaVersion, String theTableName, String ... theColumnsInOrder) {
        super(theProductVersion, theSchemaVersion);
        this.setTableName(theTableName);
        this.myPrimaryKeyColumnsInOrder = Arrays.asList(theColumnsInOrder);
    }

    @Nonnull
    private String generateSql() {
        switch (this.getDriverType()) {
            case MYSQL_5_7: 
            case MARIADB_10_1: 
            case POSTGRES_9_4: 
            case DERBY_EMBEDDED: 
            case H2_EMBEDDED: 
            case ORACLE_12C: 
            case MSSQL_2012: 
            case COCKROACHDB_21_1: {
                return String.format("ALTER TABLE %s ADD PRIMARY KEY (%s)", this.getTableName(), String.join((CharSequence)", ", this.myPrimaryKeyColumnsInOrder));
            }
        }
        throw new IllegalStateException(String.format("%s Unknown driver type.  Cannot add primary key for task %s", Msg.code((int)2531), this.getMigrationVersion()));
    }

    @Override
    protected void doExecute() throws SQLException {
        this.logInfo(ourLog, "Going to add a primary key on table {} for columns {}", this.getTableName(), this.myPrimaryKeyColumnsInOrder);
        this.executeSql(this.getTableName(), this.generateSql(), new Object[0]);
    }
}

