/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import java.sql.SQLException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropIdGeneratorTask
extends BaseTask {
    private static final Logger ourLog = LoggerFactory.getLogger(DropIdGeneratorTask.class);
    private final String myGeneratorName;

    public DropIdGeneratorTask(String theProductVersion, String theSchemaVersion, String theGeneratorName) {
        super(theProductVersion, theSchemaVersion);
        this.myGeneratorName = theGeneratorName;
    }

    @Override
    public void validate() {
        Validate.notBlank((CharSequence)this.myGeneratorName);
        this.setDescription("Drop id generator " + this.myGeneratorName);
    }

    @Override
    public void doExecute() throws SQLException {
        Set<String> tableNames = JdbcUtils.getTableNames(this.getConnectionProperties());
        String sql = null;
        switch (this.getDriverType()) {
            case MARIADB_10_1: 
            case MYSQL_5_7: {
                if (!tableNames.contains(this.myGeneratorName)) break;
                String initSql = "delete from " + this.myGeneratorName;
                this.executeSql(this.myGeneratorName, initSql, new Object[0]);
                String creationSql = "drop table " + this.myGeneratorName;
                this.executeSql(this.myGeneratorName, creationSql, new Object[0]);
                break;
            }
            case DERBY_EMBEDDED: {
                sql = "drop sequence " + this.myGeneratorName + " restrict";
                break;
            }
            case H2_EMBEDDED: {
                sql = "drop sequence " + this.myGeneratorName;
                break;
            }
            case POSTGRES_9_4: 
            case COCKROACHDB_21_1: {
                sql = "drop sequence " + this.myGeneratorName;
                break;
            }
            case ORACLE_12C: {
                sql = "drop sequence " + this.myGeneratorName;
                break;
            }
            case MSSQL_2012: {
                sql = "drop sequence " + this.myGeneratorName;
                break;
            }
            default: {
                throw new IllegalStateException(Msg.code((int)64));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            Set sequenceNames = JdbcUtils.getSequenceNames(this.getConnectionProperties()).stream().map(String::toLowerCase).collect(Collectors.toSet());
            ourLog.debug("Currently have sequences: {}", sequenceNames);
            if (!sequenceNames.contains(this.myGeneratorName.toLowerCase())) {
                this.logInfo(ourLog, "Sequence {} does not exist - No action performed", this.myGeneratorName);
                return;
            }
            this.executeSql(this.myGeneratorName, sql, new Object[0]);
        }
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        DropIdGeneratorTask otherObject = (DropIdGeneratorTask)theOtherObject;
        theBuilder.append((Object)this.myGeneratorName, (Object)otherObject.myGeneratorName);
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        theBuilder.append((Object)this.myGeneratorName);
    }
}

