/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import java.sql.SQLException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class ForceIdMigrationFixTask
extends BaseTask {
    private static final Logger ourLog = LoggerFactory.getLogger(ForceIdMigrationFixTask.class);

    public ForceIdMigrationFixTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    @Override
    public void validate() {
    }

    @Override
    protected void doExecute() throws SQLException {
        this.logInfo(ourLog, "Starting: migrate fhir_id from hfj_forced_id to hfj_resource.fhir_id", new Object[0]);
        JdbcTemplate jdbcTemplate = this.newJdbcTemplate();
        Pair range = (Pair)jdbcTemplate.queryForObject("select min(RES_ID), max(RES_ID) from HFJ_RESOURCE", (rs, rowNum) -> Pair.of((Object)rs.getLong(1), (Object)rs.getLong(2)));
        if (range == null || range.getLeft() == null) {
            this.logInfo(ourLog, "HFJ_RESOURCE is empty.  No work to do.", new Object[0]);
            return;
        }
        int rowsPerBlock = 50;
        int batchSize = rowsPerBlock * 2000;
        ourLog.info("About to migrate ids from {} to {} in batches of size {}", new Object[]{range.getLeft(), range.getRight(), batchSize});
        for (long batchStart = ((Long)range.getLeft()).longValue(); batchStart <= (Long)range.getRight(); batchStart += (long)batchSize) {
            long batchEnd = batchStart + (long)batchSize;
            ourLog.info("Migrating client-assigned ids for pids: {}-{}", (Object)batchStart, (Object)batchEnd);
            this.executeSql("hfj_resource", "update hfj_resource  set fhir_id = coalesce( " + this.trimFhirId() + " (select f.forced_id from hfj_forced_id f where f.resource_pid = res_id),    cast(res_id as varchar(64))   ) " + this.getWhereClauseByDBType() + " and res_id >= ? and res_id < ?", batchStart, batchEnd);
        }
    }

    private String trimFhirId() {
        switch (this.getDriverType()) {
            case MSSQL_2012: {
                return " LTRIM(RTRIM(fhir_id)), ";
            }
        }
        return " trim(fhir_id), ";
    }

    private String getWhereClauseByDBType() {
        switch (this.getDriverType()) {
            case MSSQL_2012: {
                return " where (fhir_id is null or DATALENGTH(fhir_id) > LEN(fhir_id)) ";
            }
        }
        return " where (fhir_id is null or fhir_id <> trim(fhir_id)) ";
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
    }
}

